<?php
/**
 * Plugin Name: Optech Core
 * Description: This is a helper plugin of optech theme
 * Version:     1.0.1
 * Author:      Mirror
 * License:     GPL2
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Domain Path: /languages
 * Text Domain: optech
 */
 // Blocking direct access
if( ! defined( 'ABSPATH' ) ) {
    exit();
}

//Defined Constants
if (!defined('OPTECH_BADGE')) {
    define('OPTECH_BADGE', '<span class="optech-badge"></span>');
}


// Define Constant
define( 'OPTECH_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
define( 'OPTECH_PLUGIN_INC_PATH', plugin_dir_path( __FILE__ ) . 'inc/' );
define( 'OPTECH_PLUGIN_CMB2EXT_PATH', plugin_dir_path( __FILE__ ) . 'cmb2-ext/' );
define( 'OPTECH_PLUGIN_WIDGET_PATH', plugin_dir_path( __FILE__ ) . 'inc/widgets/' );
define( 'OPTECH_PLUGDIRURI', plugin_dir_url( __FILE__ ) );
define( 'OPTECH_ADDONS', plugin_dir_path( __FILE__ ) .'addons/' );
define( 'OPTECH_CORE_PLUGIN_TEMP', plugin_dir_path( __FILE__ ) .'optech-template/' );

// load textdomain

add_action('init', function () {
    load_plugin_textdomain('optech', false, dirname(plugin_basename(__FILE__)) . '/languages');
});

//include file.
require_once OPTECH_PLUGIN_INC_PATH .'optechcore-functions.php';
require_once OPTECH_PLUGIN_INC_PATH .'custom-post-types.php';
require_once OPTECH_PLUGIN_INC_PATH .'icons-manager.php';
require_once OPTECH_PLUGIN_INC_PATH .'MCAPI.class.php';
require_once OPTECH_PLUGIN_INC_PATH .'optechajax.php';
require_once OPTECH_PLUGIN_INC_PATH .'builder/builder.php';
require_once OPTECH_PLUGIN_INC_PATH .'animejs/elementor-animejs.php';
require_once OPTECH_PLUGIN_INC_PATH .'sticky-header.php';

require_once OPTECH_PLUGIN_CMB2EXT_PATH . 'cmb2ext-init.php';

//Widget
require_once OPTECH_PLUGIN_WIDGET_PATH . 'recent-post-widget.php';
require_once OPTECH_PLUGIN_WIDGET_PATH . 'social-widget.php';
require_once OPTECH_PLUGIN_WIDGET_PATH . 'about-us-widget.php';
require_once OPTECH_PLUGIN_WIDGET_PATH . 'about-me-widget.php';
require_once OPTECH_PLUGIN_WIDGET_PATH . 'newsletter-widget.php';
require_once OPTECH_PLUGIN_WIDGET_PATH . 'gallery-widget.php';
require_once OPTECH_PLUGIN_WIDGET_PATH . 'event-widget.php';
require_once OPTECH_PLUGIN_WIDGET_PATH . 'video-box-widget.php';


// Custom CSS & Positioning
require_once OPTECH_PLUGIN_INC_PATH .'modules/custom-css/custom-css.php';
require_once OPTECH_PLUGIN_INC_PATH .'modules/custom-position/custom-position.php';

//addons
require_once OPTECH_ADDONS . 'addons.php';

