<?php
/**
 * @Packge     : Optech
 * @Version    : 1.0
 * @Author     : Mirror
 * @Author URI : https://www.vecurosoft.com/
 *
 */


// Blocking direct access
if( ! defined( 'ABSPATH' ) ) {
    exit;
}

function optech_core_essential_scripts( ) {
    wp_enqueue_script('optech-ajax',OPTECH_PLUGDIRURI.'assets/js/optech.ajax.js',array( 'jquery' ),'1.0',true);
    wp_localize_script(
    'optech-ajax',
    'optechajax',
        array(
            'action_url' => admin_url( 'admin-ajax.php' ),
            'nonce'	     => wp_create_nonce( 'optech-nonce' ),
        )
    );
}

add_action('wp_enqueue_scripts','optech_core_essential_scripts');


// optech Section subscribe ajax callback function
add_action( 'wp_ajax_optech_subscribe_ajax', 'optech_subscribe_ajax' );
add_action( 'wp_ajax_nopriv_optech_subscribe_ajax', 'optech_subscribe_ajax' );

function optech_subscribe_ajax( ){
  $apiKey = optech_opt('optech_subscribe_apikey');
  $listid = optech_opt('optech_subscribe_listid');
   if( ! wp_verify_nonce($_POST['security'], 'optech-nonce') ) {
    echo '<div class="alert alert-danger mt-2" role="alert">'.esc_html__('You are not allowed.', 'optech').'</div>';
   }else{
       if( !empty( $apiKey ) && !empty( $listid )  ){
           $MailChimp = new DrewM\MailChimp\MailChimp( $apiKey );

           $result = $MailChimp->post("lists/{$listid}/members",[
               'email_address'    => esc_attr( $_POST['sectsubscribe_email'] ),
               'status'           => 'subscribed',
           ]);

           if ($MailChimp->success()) {
               if( $result['status'] == 'subscribed' ){
                   echo '<div class="alert alert-success mt-2" role="alert">'.esc_html__('Thank you, you have been added to our mailing list.', 'optech').'</div>';
               }
           }elseif( $result['status'] == '400' ) {
               echo '<div class="alert alert-danger mt-2" role="alert">'.esc_html__('This Email address is already exists.', 'optech').'</div>';
           }else{
               echo '<div class="alert alert-danger mt-2" role="alert">'.esc_html__('Sorry something went wrong.', 'optech').'</div>';
           }
        }else{
           echo '<div class="alert alert-danger mt-2" role="alert">'.esc_html__('Apikey Or Listid Missing.', 'optech').'</div>';
        }
   }

   wp_die();

}