<?php
    /**
     * Class For Builder
     */
    class OptechBuilder{

        function __construct(){
            // register admin menus
        	add_action( 'admin_menu', [$this, 'register_settings_menus'] );

            // Custom Footer Builder With Post Type
			add_action( 'init',[ $this,'post_type' ],0 );

 		    add_action( 'elementor/frontend/after_enqueue_scripts', [ $this,'widget_scripts'] );

			add_filter( 'single_template', [ $this, 'load_canvas_template' ] );

            add_action( 'elementor/element/wp-page/document_settings/after_section_end', [ $this,'optech_add_elementor_page_settings_controls' ],10,2 );

		}

		public function widget_scripts( ) {
			wp_enqueue_script( 'optech-core',OPTECH_PLUGDIRURI.'assets/js/optech-core.js',array( 'jquery' ),'1.0',true );
		}


        public function optech_add_elementor_page_settings_controls( \Elementor\Core\DocumentTypes\Page $page ){

			$page->start_controls_section(
                'optech_header_option',
                [
                    'label'     => __( 'Header Option', 'optech' ),
                    'tab'       => \Elementor\Controls_Manager::TAB_SETTINGS,
                ]
            );


            $page->add_control(
                'optech_header_style',
                [
                    'label'     => __( 'Header Option', 'optech' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => [
    					'prebuilt'             => __( 'Pre Built', 'optech' ),
    					'header_builder'       => __( 'Header Builder', 'optech' ),
    				],
                    'default'   => 'prebuilt',
                ]
			);

            $page->add_control(
                'optech_header_builder_option',
                [
                    'label'     => __( 'Header Name', 'optech' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => $this->optech_header_choose_option(),
                    'condition' => [ 'optech_header_style' => 'header_builder'],
                    'default'	=> ''
                ]
            );

            $page->end_controls_section();

            $page->start_controls_section(
                'optech_footer_option',
                [
                    'label'     => __( 'Footer Option', 'optech' ),
                    'tab'       => \Elementor\Controls_Manager::TAB_SETTINGS,
                ]
            );
            $page->add_control(
    			'optech_footer_choice',
    			[
    				'label'         => __( 'Enable Footer?', 'optech' ),
    				'type'          => \Elementor\Controls_Manager::SWITCHER,
    				'label_on'      => __( 'Yes', 'optech' ),
    				'label_off'     => __( 'No', 'optech' ),
    				'return_value'  => 'yes',
    				'default'       => 'yes',
    			]
    		);
            $page->add_control(
                'optech_footer_style',
                [
                    'label'     => __( 'Footer Style', 'optech' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => [
    					'prebuilt'             => __( 'Pre Built', 'optech' ),
    					'footer_builder'       => __( 'Footer Builder', 'optech' ),
    				],
                    'default'   => 'prebuilt',
                    'condition' => [ 'optech_footer_choice' => 'yes' ],
                ]
            );
            $page->add_control(
                'optech_footer_builder_option',
                [
                    'label'     => __( 'Footer Name', 'optech' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => $this->optech_footer_choose_option(),
                    'condition' => [ 'optech_footer_style' => 'footer_builder','optech_footer_choice' => 'yes' ],
                    'default'	=> ''
                ]
            );

			$page->end_controls_section();

        }

		public function register_settings_menus(){
			add_menu_page(
				esc_html__( 'Optech Builder', 'optech' ),
            	esc_html__( 'Optech Builder', 'optech' ),
				'manage_options',
				'optech',
				[$this,'register_settings_contents__settings'],
				'dashicons-admin-site',
				2
			);

			add_submenu_page('optech', esc_html__('Footer Builder', 'optech'), esc_html__('Footer Builder', 'optech'), 'manage_options', 'edit.php?post_type=optech_footer');
			add_submenu_page('optech', esc_html__('Header Builder', 'optech'), esc_html__('Header Builder', 'optech'), 'manage_options', 'edit.php?post_type=optech_header');
			add_submenu_page('optech', esc_html__('Tab Builder', 'optech'), esc_html__('Tab Builder', 'optech'), 'manage_options', 'edit.php?post_type=optech_tab_build');
			add_submenu_page('optech', esc_html__('OFF Canvas Builder', 'optech'), esc_html__('OFF Canvas Builder', 'optech'), 'manage_options', 'edit.php?post_type=optech_off_build');
		}

		// Callback Function
		public function register_settings_contents__settings(){
            echo '<h2>';
			    echo esc_html__( 'Welcome To Header And Footer Builder Of This Theme','optech' );
            echo '</h2>';
		}

		public function post_type() {

			$labels = array(
				'name'               => __( 'Footer', 'optech' ),
				'singular_name'      => __( 'Footer', 'optech' ),
				'menu_name'          => __( 'Optech Footer Builder', 'optech' ),
				'name_admin_bar'     => __( 'Footer', 'optech' ),
				'add_new'            => __( 'Add New', 'optech' ),
				'add_new_item'       => __( 'Add New Footer', 'optech' ),
				'new_item'           => __( 'New Footer', 'optech' ),
				'edit_item'          => __( 'Edit Footer', 'optech' ),
				'view_item'          => __( 'View Footer', 'optech' ),
				'all_items'          => __( 'All Footer', 'optech' ),
				'search_items'       => __( 'Search Footer', 'optech' ),
				'parent_item_colon'  => __( 'Parent Footer:', 'optech' ),
				'not_found'          => __( 'No Footer found.', 'optech' ),
				'not_found_in_trash' => __( 'No Footer found in Trash.', 'optech' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);

			register_post_type( 'optech_footer', $args );

			$labels = array(
				'name'               => __( 'Header', 'optech' ),
				'singular_name'      => __( 'Header', 'optech' ),
				'menu_name'          => __( 'Optech Header Builder', 'optech' ),
				'name_admin_bar'     => __( 'Header', 'optech' ),
				'add_new'            => __( 'Add New', 'optech' ),
				'add_new_item'       => __( 'Add New Header', 'optech' ),
				'new_item'           => __( 'New Header', 'optech' ),
				'edit_item'          => __( 'Edit Header', 'optech' ),
				'view_item'          => __( 'View Header', 'optech' ),
				'all_items'          => __( 'All Header', 'optech' ),
				'search_items'       => __( 'Search Header', 'optech' ),
				'parent_item_colon'  => __( 'Parent Header:', 'optech' ),
				'not_found'          => __( 'No Header found.', 'optech' ),
				'not_found_in_trash' => __( 'No Header found in Trash.', 'optech' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);

			register_post_type( 'optech_header', $args );

            $labels = array(
				'name'               => __( 'Tab Builder', 'optech' ),
				'singular_name'      => __( 'Tab Builder', 'optech' ),
				'menu_name'          => __( 'Optech Tab Builder', 'optech' ),
				'name_admin_bar'     => __( 'Tab Builder', 'optech' ),
				'add_new'            => __( 'Add New', 'optech' ),
				'add_new_item'       => __( 'Add New Tab Builder', 'optech' ),
				'new_item'           => __( 'New Tab Builder', 'optech' ),
				'edit_item'          => __( 'Edit Tab Builder', 'optech' ),
				'view_item'          => __( 'View Tab Builder', 'optech' ),
				'all_items'          => __( 'All Tab Builder', 'optech' ),
				'search_items'       => __( 'Search Tab Builder', 'optech' ),
				'parent_item_colon'  => __( 'Parent Tab Builder:', 'optech' ),
				'not_found'          => __( 'No Tab Builder found.', 'optech' ),
				'not_found_in_trash' => __( 'No Tab Builder found in Trash.', 'optech' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);
			register_post_type( 'optech_tab_build', $args );

			//Off Canvas builder
            $labels = array(
				'name'               => __( 'Off Canvas Builder', 'optech' ),
				'singular_name'      => __( 'Off Canvas Builder', 'optech' ),
				'menu_name'          => __( 'Optech Off Canvas Builder', 'optech' ),
				'name_admin_bar'     => __( 'Off Canvas Builder', 'optech' ),
				'add_new'            => __( 'Add New', 'optech' ),
				'add_new_item'       => __( 'Add New Off Canvas Builder', 'optech' ),
				'new_item'           => __( 'New Off Canvas Builder', 'optech' ),
				'edit_item'          => __( 'Edit Off Canvas Builder', 'optech' ),
				'view_item'          => __( 'View Off Canvas Builder', 'optech' ),
				'all_items'          => __( 'All Off Canvas Builder', 'optech' ),
				'search_items'       => __( 'Search Off Canvas Builder', 'optech' ),
				'parent_item_colon'  => __( 'Parent Off Canvas Builder:', 'optech' ),
				'not_found'          => __( 'No Off Canvas Builder found.', 'optech' ),
				'not_found_in_trash' => __( 'No Off Canvas Builder found in Trash.', 'optech' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);
			register_post_type( 'optech_off_build', $args );

		}

		function load_canvas_template( $single_template ) {

			global $post;

			if ( 'optech_footer' == $post->post_type || 'optech_header' == $post->post_type || 'optech_tab_build' == $post->post_type || 'optech_off_build' == $post->post_type  ) {

				$elementor_2_0_canvas = ELEMENTOR_PATH . '/modules/page-templates/templates/canvas.php';

				if ( file_exists( $elementor_2_0_canvas ) ) {
					return $elementor_2_0_canvas;
				} else {
					return ELEMENTOR_PATH . '/includes/page-templates/canvas.php';
				}
			}

			return $single_template;
		}

        public function optech_footer_choose_option(){

			$optech_post_query = new WP_Query( array(
				'post_type'			=> 'optech_footer',
				'posts_per_page'	    => -1,
			) );

			$optech_builder_post_title = array();
			$optech_builder_post_title[''] = __('Select a Footer','Optech');

			while( $optech_post_query->have_posts() ) {
				$optech_post_query->the_post();
				$optech_builder_post_title[ get_the_ID() ] =  get_the_title();
			}
			wp_reset_postdata();

			return $optech_builder_post_title;

		}

		public function optech_header_choose_option(){

			$optech_post_query = new WP_Query( array(
				'post_type'			=> 'optech_header',
				'posts_per_page'	    => -1,
			) );

			$optech_builder_post_title = array();
			$optech_builder_post_title[''] = __('Select a Header','Optech');

			while( $optech_post_query->have_posts() ) {
				$optech_post_query->the_post();
				$optech_builder_post_title[ get_the_ID() ] =  get_the_title();
			}
			wp_reset_postdata();

			return $optech_builder_post_title;

        }

    }

    $builder_execute = new OptechBuilder();