<?php


class Optech_Text_Slider_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'optech_text_slider_widget';
	}

	public function get_title() {
		return esc_html__( 'Optech Text Slider', 'optech' );
	}

	public function get_icon() {
		return 'eicon-code';
	}

	public function get_categories() {
		return [ 'optech-addons' ];
	}

	public function get_keywords() {
		return [ 'text', 'animate', 'infinite', ' slider' ];
	}

  protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'optech' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
        $repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'optech_text_slider_title',
			[
				'label' => esc_html__( 'Text', 'optech' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Default title', 'optech' ),
				'placeholder' => esc_html__( 'Type your title here', 'optech' ),
				'label_block' => true
			]
		);
        $repeater->add_control(
			'optech_text_slider_icon',
			[
				'label' 	=> __( 'Icon', 'optech' ),
				'type' 		=> \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' 	=> \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'optech_text_slider_list',
			[
				'label' => esc_html__( 'Repeater List', 'optech' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'optech_text_slider_title' => esc_html__( 'COLLECT RARE AND EXTRAORDINARY ARTWORK', 'optech' ),
						'optech_text_slider_icon' => esc_html__( 'Item content. Click the edit button to change this text.', 'optech' ),
					],
				
				],
				'title_field' => '{{{ optech_text_slider_title }}}',
			]
		);
		$this->end_controls_section();

		// setting slider
		$this->start_controls_section(
			'optech_text_slider_setting',
			[
				'label' => esc_html__( 'Setting', 'optech' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_responsive_control(
            'per_coulmn',
            [
                'label' => __('Slider Per Column Items', 'optech'),
                'type' =>  \Elementor\Controls_Manager::SELECT,
                'default'            => 3,
                'tablet_default'     => 2,
                'mobile_default'     => 1,
                'options'            => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                    '7' => '7',
                    '8' => '8',
                    '9' => '9',
                    '10' => '10',
                ],
                'frontend_available' => true,
            ]
        );
		$this->add_responsive_control(
            'slide_scroll',
            [
                'label' => __('Slider Scroll Items', 'mthemeus-addons'),
                'type' =>  \Elementor\Controls_Manager::SELECT,
                'default'            => 1,
                'options'            => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                    '7' => '7',
                    '8' => '8',
                    '9' => '9',
                    '10' => '10',
                ],
                'frontend_available' => true,
            ]
        );
		$this->add_control(
			'autoplay',
			[
				'label' => esc_html__( 'Autoplay?', 'optech' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'true', 'optech' ),
				'label_off' => esc_html__( 'false', 'optech' ),
				'return_value' => 'true',
				'default' => 'true',
			]
		);
        $this->add_control(
			'speed',
			[
				'label' => __('Autoplay Timeout', 'optech'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'label_block' => true,
				'default' => '5000',
				'options' => [
					'1000'  => __('1 Second', 'optech'),
					'2000'  => __('2 Second', 'optech'),
					'3000'  => __('3 Second', 'optech'),
					'4000'  => __('4 Second', 'optech'),
					'5000'  => __('5 Second', 'optech'),
					'6000'  => __('6 Second', 'optech'),
					'7000'  => __('7 Second', 'optech'),
					'8000'  => __('8 Second', 'optech'),
					'9000'  => __('9 Second', 'optech'),
					'10000' => __('10 Second', 'optech'),
					'11000' => __('11 Second', 'optech'),
					'12000' => __('12 Second', 'optech'),
					'13000' => __('13 Second', 'optech'),
					'14000' => __('14 Second', 'optech'),
					'15000' => __('15 Second', 'optech'),
				],
				'condition' => [
					'autoplay' => 'yes',
				],
			]
		);
		$this->add_control(
			'optech_slider_rtl',
			[
				'label' => esc_html__( 'Rtl?', 'optech' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'true', 'optech' ),
				'label_off' => esc_html__( 'false', 'optech' ),
				'return_value' => 'true',
				'default' => 'true',
			]
		);
		$this->end_controls_section();
		
		// Text Style
		$this->start_controls_section(
			'optech_text_slider_style',
			[
				'label' => esc_html__( 'Text', 'optech' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'optech_text_slider_color',
			[
				'label' => esc_html__( 'Text Color', 'optech' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-brand-item h3' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'optech_text_slider_bg_color',
			[
				'label' => esc_html__( 'Text Background Color', 'optech' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-brand-item h3' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'optech_text_slider_typography',
				'selector' => '{{WRAPPER}} .optech-brand-item h3',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'optech_text_slider_text_shadow',
				'label' => esc_html__( 'Text Shadow', 'optech' ),
				'selector' => '{{WRAPPER}} .optech-brand-item h3',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'optech_text_slider_border',
				'selector' => '{{WRAPPER}} .optech-brand-item h3',
			]
		);
		$this->add_control(
			'optech_text_slider_padding',
			[
				'label' => esc_html__( 'Padding', 'optech' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .optech-brand-item h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'optech_text_slider_margin',
			[
				'label' => esc_html__( 'Margin', 'optech' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .optech-brand-item h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

		// Icon
		$this->start_controls_section(
			'optech_icon_slider_style',
			[
				'label' => esc_html__( 'Icon', 'optech' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_responsive_control(
            'slider_icon_width',
            [
                'label'          => __('Width', 'optech'),
                'type'           => \Elementor\Controls_Manager::SLIDER,
                'size_units'     => ['%', 'px','vw'],
                'range'          => [
                    '%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .optech-brand-item img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'slider_icon_height',
            [
                'label'          => __('Height', 'optech'),
                'type'           => \Elementor\Controls_Manager::SLIDER,
                'size_units'     => ['px','%', 'vh'],
                'range'          => [
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    '%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'vh' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .optech-brand-item img' => 'height: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );
		$this->add_responsive_control(
			'optech_icon_slider_margin',
			[
				'label' => esc_html__( 'Margin', 'optech' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .optech-brand-item img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'optech_icon_slider_padding',
			[
				'label' => esc_html__( 'Padding', 'optech' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .optech-brand-item img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

	}

  protected function render() {
    	$settings = $this->get_settings_for_display();
		$optech_text_slider_list = $settings['optech_text_slider_list'];

		$slider_rtl = $settings['optech_slider_rtl'];

		if($slider_rtl == 'true'){
			$rtl_open = 'rtl';
		}else{
			$rtl_open = '';
		};


		$slider_extraSetting = array(
			'autoplay' => (!empty($settings['autoplay']) && 'yes' === $settings['autoplay']) ? true : false,
			'slider_rtl' => (!empty( $slider_rtl) && 'true' ===  $slider_rtl) ? true : false,
			'speed' => !empty($settings['speed']) ? $settings['speed'] : '3000',
			'slide_scroll' => !empty($settings['slide_scroll']) ? $settings['slide_scroll'] : 1,

			//this a responsive layout
			'per_coulmn' => (!empty($settings['per_coulmn'])) ? $settings['per_coulmn'] : 3,
			'per_coulmn_tablet' => (!empty($settings['per_coulmn_tablet'])) ? $settings['per_coulmn_tablet'] : 2,
			'per_coulmn_mobile' => (!empty($settings['per_coulmn_mobile'])) ? $settings['per_coulmn_mobile'] : 1
		);
		$jasondecode = wp_json_encode($slider_extraSetting);


		$this->add_render_attribute('slider_version', 'class', array('optech-brand-slider'));
		$this->add_render_attribute('slider_version', 'data-settings', $jasondecode);

	?>

   		<div dir="<?php echo esc_attr($rtl_open); ?>" >
			<div <?php echo $this->get_render_attribute_string('slider_version'); ?> >
				<?php foreach ($optech_text_slider_list as $optech_text_slider_lists) : ?>
                        <div class="optech-brand-item">
                            <img src="<?php echo esc_url( $optech_text_slider_lists['optech_text_slider_icon']['url'] ); ?>" alt="">
                            <?php if($optech_text_slider_lists['optech_text_slider_title']): ?>
								<h3>
									<?php echo esc_html($optech_text_slider_lists['optech_text_slider_title'])?>
								</h3>
							<?php endif; ?>
                        </div>
					<?php endforeach; ?>
				</div>
			</div>

		<?php
   
 	 }

}

$widgets_manager->register( new \Optech_Text_Slider_Widget() );