<div class="optech-portfolio-wrap2">
    <div class="optech-portfolio-thumb2">
        <?php if( has_post_thumbnail() ): ?>
            <?php the_post_thumbnail('full');?>
        <?php endif; ?>
    </div>

    <div class="optech-portfolio-data2-wrap">
        <div class="optech-portfolio-data2 optech-content">
            <a href="<?php the_permalink(); ?>">
                <h4><?php the_title(); ?></h4>
            </a>
            <p>
                <?php
                    $terms = get_the_terms(get_the_ID(), 'project_category');
                    if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
                        $term_names = array();
                        foreach ( $terms as $term ) {
                            $term_names[] = esc_html( $term->name );
                        }
                        echo implode(', ', $term_names);
                    }
                ?>
            </p>
        </div>
        
        <?php if ( ! empty( $item['optech_project_icon']['value'] ) ) : ?>
            <a class="optech-portfolio-btn2 opp-custom-btn" href="<?php the_permalink(); ?>">
                <span class="p-btn-wraper">
                    <?php \Elementor\Icons_Manager::render_icon( $item['optech_project_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                </span>
            </a>
        <?php endif; ?>
    </div>
</div>