<?php

if (!defined('ABSPATH')) {
    exit;
}

class Optech_project_Slider extends \Elementor\Widget_Base {

	public function get_name() {
		return 'optech_projects';
	}

	public function get_title() {
		return esc_html__( 'projects', 'optech' );
	}

	public function get_icon() {
		return 'eicon-code';
	}

	public function get_categories() {
		return [ 'optech-addons' ];
	}

	public function get_keywords() {
		return [ 'project', 'normal', ' slider' ];
	}

    protected function register_controls() {

        $this->start_controls_section(
            'project_settings',
            [
                'label' => __('project Settings', 'optech'),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'show_slider_settings',
            [
                'label' => __('Slider Active', 'optech'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'optech'),
                'label_off' => __('No', 'optech'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_responsive_control(
            'gap_bottom',
            [
                'label'          => __('Gap Bottom', 'optech'),
                'type'           => \Elementor\Controls_Manager::SLIDER,
                'size_units'     => ['px', '%'],
                'range'          => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .optech-portfolio-wrap, .optech-portfolio-wrap2' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        //Control the number of posts shown
        $this->add_control(
            'posts_per_page',
            [
                'label' => __('Posts Per Page', 'aidzone'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 6, // Default posts per page
                'condition' => [ 'show_slider_settings' => '',  ]
                
            ]
        );
        $this->end_controls_section();

        // Slider Setting
        $this->start_controls_section('slider_settings',
        [
            'label' => __('Slider Settings', 'optech'),
            'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            'condition' => [ 'show_slider_settings' => 'yes',  ]
            ]
        );
        $this->add_responsive_control(
            'per_coulmn',
            [
                'label' => __( 'Slider Items', 'optech' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default'            => 3,
                'tablet_default'     => 2,
                'mobile_default'     => 1,
                'options'            => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                ],
                'frontend_available' => true,
            ]
        );
        $this->add_responsive_control(
			'gap_right_left',
			[
				'label'          => __('Row Gap(Right-Left)', 'optech'),
				'type'           => \Elementor\Controls_Manager::SLIDER,
				'size_units'     => ['px', '%'],
				'range'          => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors'      => [
					'{{WRAPPER}} .optech-3column-slider .slick-slide' => 'margin-right: {{SIZE}}{{UNIT}}; margin-left: {{SIZE}}{{UNIT}};',
				],
			]
		);	
        $this->add_control(
            'center_mode',
            [
                'label' => __( 'Center Mode?', 'optech' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'optech' ),
                'label_off' => __( 'Hide', 'optech' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'dots',
            [
                'label' => __( 'Dots?', 'optech' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'optech' ),
                'label_off' => __( 'Hide', 'optech' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'drag',
            [
                'label' => __( 'Drag?', 'optech' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'optech' ),
                'label_off' => __( 'Hide', 'optech' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'autoplay',
            [
                'label' => __( 'Auto Play?', 'optech' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'optech' ),
                'label_off' => __( 'Hide', 'optech' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'autoplaytimeout',
            [
                'label' => __( 'Autoplay Timeout', 'optech' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'label_block' => true,
                'default' => '5000',
                'options' => [
                    '1000'  => __( '1 Second', 'optech' ),
                    '2000'  => __( '2 Second', 'optech' ),
                    '3000'  => __( '3 Second', 'optech' ),
                    '4000'  => __( '4 Second', 'optech' ),
                    '5000'  => __( '5 Second', 'optech' ),
                    '6000'  => __( '6 Second', 'optech' ),
                    '7000'  => __( '7 Second', 'optech' ),
                    '8000'  => __( '8 Second', 'optech' ),
                    '9000'  => __( '9 Second', 'optech' ),
                    '10000' => __( '10 Second', 'optech' ),
                    '11000' => __( '11 Second', 'optech' ),
                    '12000' => __( '12 Second', 'optech' ),
                    '13000' => __( '13 Second', 'optech' ),
                    '14000' => __( '14 Second', 'optech' ),
                    '15000' => __( '15 Second', 'optech' ),
                ],
                'condition' => [
                    'autoplay' => 'yes',
                ],
            ]
        );
        $this->end_controls_section();
        // End Slider settings

        // Start project Section
        $this->start_controls_section(
			'project_section',
			[
				'label' => esc_html__( 'project Section', 'optech' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
            'project_style', 
            [
                'label' => esc_html__('Select Style', 'optech'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '1' => esc_html__('Style 1', 'optech'),
                    '2' => esc_html__('Style 2', 'optech'),
                ],
                'default' => '1',
            ]
        );
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'select_post',
            [
                'label' => __('Must be Select a Post', 'optech'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'label_block' => true,
                'default' => 'none',
                'options' => $this->get_all_projects(),
            ]
        );
        $repeater->add_control('per_line', [
            'label'              => __('Columns', 'optech'),
            'type'               => \Elementor\Controls_Manager::SELECT,
            'default'            => '4',
            'options'            => [
                '12' => '12',
                '8'  => '8',
                '6'  => '6',
                '4'  => '4',
                '3'  => '3',
            ],
            'frontend_available' => true,
        ]);
        $repeater->add_control(
			'optech_project_icon',
			[
				'label'       => __( 'Icon', 'optech' ),
				'type'        => \Elementor\Controls_Manager::ICONS,
				'label_block' => true,
			]
		);
        $this->add_control(
            'project_lists',
            [
                'label' => __('project Lists', 'optech'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );
		$this->end_controls_section();

        // start img style
        $this->start_controls_section(
            'project_img_style',
            [
                    'label' => __('Image', 'optech'),
                    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'img_width',
            [
                'label'          => __('Width', 'optech'),
                'type'           => \Elementor\Controls_Manager::SLIDER,
                'size_units'     => ['%', 'px','vw'],
                'range'          => [
                    '%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .optech-portfolio-thumb img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'img_height',
            [
                'label'          => __('Height', 'optech'),
                'type'           => \Elementor\Controls_Manager::SLIDER,
                'size_units'     => ['px','%', 'vh'],
                'range'          => [
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    '%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'vh' => [
                        'min' => 1,
                        'max' => 100,
                    ], 
                ],
                'selectors'      => [
                    '{{WRAPPER}} .optech-portfolio-thumb img' => 'height: {{SIZE}}{{UNIT}} !important;',
                    '{{WRAPPER}} .optech-portfolio-thumb2 img' => 'height: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );
		$this->add_control(
			'image_object_fit',
			[
				'label' => esc_html__( 'Object Fit', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'cover',
				'options' => [
					'none' => esc_html__( 'None', 'textdomain' ),
					'fill' => esc_html__( 'Fill', 'textdomain' ),
					'contain' => esc_html__( 'Contain', 'textdomain' ),
					'cover'  => esc_html__( 'Cover', 'textdomain' ),
				],
				'selectors' => [
					'{{WRAPPER}} .optech-portfolio-thumb img' => 'object-fit: {{VALUE}};',
					'{{WRAPPER}} .optech-portfolio-thumb2 img' => 'object-fit: {{VALUE}};',
				],
				'condition' => [
                    'img_height[size]!' => '',
                ],
			]
		);
		
		$this->add_control(
			'image_object-position',
			[
				'label' => esc_html__( 'Object Fit', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'center center',
				'options' => [
					'right bottom' => esc_html__( 'Right Bottom', 'textdomain' ),
					'center center' => esc_html__( 'Center Center', 'textdomain' ),
					'left bottom' => esc_html__( 'Left Bottom', 'textdomain' ),
					'left top'  => esc_html__( 'Left top', 'textdomain' ),
					'right top'  => esc_html__( 'right top', 'textdomain' ),
				],
				'selectors' => [
					'{{WRAPPER}} .optech-portfolio-thumb img' => 'object-position: {{VALUE}};',
					'{{WRAPPER}} .optech-portfolio-thumb2 img' => 'object-position: {{VALUE}};',
				],
				'condition' => [
                    'img_height[size]!' => '',
                ],
			]
		);
		
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'img_box_before_background',
                'background_types' => [ 'background color', 'gradient' ], 
                'types' => [ 'background color', 'gradient' ], 
                'selector' => '{{WRAPPER}} .optech-portfolio-thumb::before',
                'condition' => [ 'project_style' => '1',  ]
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'img_box_hover_background',
                'background_types' => [ 'background color', 'gradient' ], 
                'types' => [ 'background color', 'gradient' ], 
                'selector' => '{{WRAPPER}} .optech-portfolio-thumb::after',
                'condition' => [ 'project_style' => '1',  ]
            ]
        );

        $this->add_control(
			'box_bg_color',
			[
				'label' => esc_html__( 'Background Color', 'optech' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-portfolio-wrap2' => 'color: {{VALUE}}',
				],
                'condition' => [ 'project_style' => '2',  ]
			]
		);

        $this->add_responsive_control(
			'img_border_radius',
			[
				'label' 		=> __( 'Border Radius', 'optech' ),
				'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .optech-portfolio-thumb' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .optech-portfolio-wrap2' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

        $this->add_responsive_control(
			'img_padding',
			[
				'label' 		=> __( 'Padding', 'optech' ),
				'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .optech-portfolio-data2-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [ 'project_style' => '2',  ]
			]
		);
		$this->end_controls_section();

        // start Title style
        $this->start_controls_section(
            'project_title_style',
            [
                    'label' => __('Title', 'optech'),
                    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'title_style_tabs'
        );
        $this->start_controls_tab(
                'title_style_normal_tab',
                [
                        'label' => __('Normal', 'optech'),
                ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .optech-content h4',
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Color', 'optech' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-content h4' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_responsive_control(
			'title_margin',
			[
				'label' => esc_html__( 'Margin', 'optech' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .optech-content h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);
		$this->add_responsive_control(
			'title_padding',
			[
				'label' => esc_html__( 'Padding', 'optech' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .optech-content h4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);
        $this->end_controls_tab();

        $this->start_controls_tab(
            'title_style_hover_tab',
            [
                    'label' => __('Hover', 'optech'),
            ]
        );
        $this->add_control(
			'title_hover_color',
			[
				'label' => esc_html__( 'Color', 'optech' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-content h4:hover' => 'color: {{VALUE}}',
				],
			]
		);
        $this->end_controls_tab();
        $this->end_controls_tabs();
		$this->end_controls_section();

         // start category style
         $this->start_controls_section(
            'team_category_style',
            [
                    'label' => __('Category', 'optech'),
                    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'category_typography',
				'selector' => '{{WRAPPER}} .optech-content p',
			]
		);
		$this->add_control(
			'category_color',
			[
				'label' => esc_html__( 'Color', 'optech' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-content p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();

        // icon Style
        $this->start_controls_section(
			'icon_style_section',
			[
				'label' 	=> __( 'Icon', 'optech' ),
				'tab' 		=> \Elementor\Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
			'icon_color',
			[
				'label' 		=> __( 'Icon Color', 'optech' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .opp-custom-btn i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .opp-custom-btn svg' => 'fill: {{VALUE}}',
					'{{WRAPPER}} .opp-custom-btn stroke' => 'color: {{VALUE}}',
                ],
			]
        );
        $this->add_control(
            'stroke_color',
            [
                'label'     => __( 'Stroke Color', 'optech' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .opp-custom-btn svg' => 'stroke: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
			'icon_bg_color',
			[
				'label' 		=> __( 'Background Color', 'optech' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .opp-custom-btn' => 'background-color: {{VALUE}}',
                ],
			]
        );
        $this->add_control(
			'icon_bg_color_hover',
			[
				'label' 		=> __( 'Background Hover Color', 'optech' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .opp-custom-btn:hover' => 'background-color: {{VALUE}}',
                ],
			]
        );
        $this->add_control(
			'icon_size',
			[
				'label' => esc_html__( 'Size', 'optech' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 30,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .opp-custom-btn i' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .opp-custom-btn svg' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_control(
			'icon_box_size',
			[
				'label' => esc_html__( 'Box Size', 'optech' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 30,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .opp-custom-btn' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
			'iconbox_radius',
			[
				'label' => esc_html__( 'Border Radius', 'optech' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .opp-custom-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
		);
		$this->end_controls_section();

        // start Dots style
        $this->start_controls_section(
            'project_dots_style',
            [
                    'label' => __('Dots', 'optech'),
                    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
			'dots_color',
			[
					'label'     => __('Color', 'optech'),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
							'{{WRAPPER}} .slick-dots button' => 'background-color: {{VALUE}} !important',
					],
			]
		);
        $this->add_responsive_control(
			'dots_active_color',
			[
					'label'     => __('Active Color', 'optech'),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
							'{{WRAPPER}} .slick-dots li.slick-active button' => 'background-color: {{VALUE}} !important',
					],
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'dots_border',
				'label' => esc_html__( 'Border', 'optech' ),
				'selector' => '{{WRAPPER}} .slick-dots button:before',
			]
		);
		$this->end_controls_section();


	}

    // Get All projects
    public function get_all_projects() {

        $wp_query = get_posts([
            'post_type' => 'optech_project',
            'orderby' => 'date',
            'posts_per_page' => -1,
        ]);

        $options = ['none' => 'None'];
        foreach ($wp_query as $projects) {
            $options[$projects->ID] = $projects->post_title;
        }

        return $options;
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        //this code course slider option
		$slider_extraSetting = array(
	        'autoplay' => (!empty($settings['autoplay']) && 'yes' === $settings['autoplay']) ? true : false,
            'drag' => (!empty($settings['drag']) && 'yes' === $settings['drag']) ? true : false,
            'dots' => (!empty($settings['dots']) && 'yes' === $settings['dots']) ? true : false,
            'centermode' => (!empty($settings['center_mode']) && 'yes' === $settings['center_mode']) ? true : false,
        	'autoplaytimeout' => !empty($settings['autoplaytimeout']) ? $settings['autoplaytimeout'] : '5000',

        	//this a responsive layout
            'per_coulmn' =>        (!empty($settings['per_coulmn'])) ? $settings['per_coulmn'] : 3,
            'per_coulmn_tablet' => (!empty($settings['per_coulmn_tablet'])) ? $settings['per_coulmn_tablet'] : 2,
            'per_coulmn_mobile' => (!empty($settings['per_coulmn_mobile'])) ? $settings['per_coulmn_mobile'] : 1
        );
        $jasondecode = wp_json_encode($slider_extraSetting);

        if ( ( 'yes' == $settings['show_slider_settings'] ) ) {
            $this->add_render_attribute('project_version', 'class', ['row project-slide optech-3column-slider']);
            $this->add_render_attribute('project_version', 'data-settings', $jasondecode);
            $this->add_render_attribute('project_gride_classes', 'class', ['item']);
        } else {
            $this->add_render_attribute('project_version', 'class', ['row']);
        }

        $project_style = $settings['project_style'];
        $project_lists = $settings['project_lists'];?>  

        <div <?php echo $this->get_render_attribute_string('project_version'); ?>>
        
            <?php
            $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
            $posts_per_page = $settings['posts_per_page']; 

            $post_ids = array_map(function($item) {
                return $item['select_post'];
            }, $project_lists);

            $args = new \WP_Query(array(
                'post_type' => 'optech_project',
                'post_status' => 'publish',
                'post__in' => $post_ids,
                'posts_per_page' => $posts_per_page,
                'paged' => $paged,
            ));

            if ($args->have_posts()) :
                while ($args->have_posts()) : $args->the_post();
                    foreach ($project_lists as $item) :
                        // Convert $item['select_post'] to an array to avoid errors
                        if (in_array(get_the_ID(), (array) $item['select_post'])) :
                            ?>
                            <div class="col-xl-<?php echo esc_attr($item['per_line']); ?> col-md-6">
                                <?php 
                                if ($project_style) {
                                    include('project/'.$project_style.'.php');
                                }
                                ?>
                            </div>
                            <?php
                        endif;
                    endforeach;
                endwhile;
                wp_reset_postdata();
            else :
                echo '<p>No projects found.</p>';
            endif;
            ?>
        </div>
        <?php if ( empty( $settings['show_slider_settings'] ) ): ?>
        <div class="row">
            <div class="col-md-12">
                <?php
                $pages = paginate_links(array(
                    'total' => $args->max_num_pages,
                    'current' => $paged,
                    'type' => 'array',
                    'prev_text' => __('<i class="ri-arrow-left-s-line"></i>', 'optech'),
                    'next_text' => __('<i class="ri-arrow-right-s-line"></i>', 'optech'),
                ));

                if ($pages) {
                    echo '<div class="optech-pagination justify-content-center"><ul>';
                    foreach ($pages as $page) {
                        echo "<li>$page</li>";
                    }
                    echo '</ul></div>';
                }
                
                ?>
            </div>
        </div>
        <?php endif?>
        <?php
    }

}

$widgets_manager->register( new \Optech_project_Slider() );