<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Repeater;
/**
 *
 * Progress Bar Widget .
 *
 */
class Optech_Progress_Bar extends Widget_Base {

	public function get_name() {
		return 'optechprogressbar';
	}

	public function get_title() {
		return __( 'Progress Bar', 'optech' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'optech' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'progress_bar_section',
			[
				'label'		 	=> __( 'Progress Bar', 'optech' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );

        $repeater = new Repeater();

        $repeater->add_control(
			'progress_bar_title',
			[
				'label' 	=> __( 'Progress Bar Title', 'optech' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'IT Solution & Management', 'optech' )
			]
        );
        $repeater->add_control(
			'progress_bar_width',
			[
				'label' 		=> __( 'Bar Width', 'optech' ),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> [ '%' ],
				'range' 		=> [
					'%' 			=> [
						'min' 			=> 0,
						'max' 			=> 100,
						'step'			=> 5,
					],
				],
				'default' 	=> [
					'unit' 		=> '%',
					'size' 		=> 80,
				],
			]
		);
		$this->add_control(
			'progress_bar_repeater',
			[
				'label' 		=> __( 'Progress Bar', 'optech' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
			]
		);
        $this->end_controls_section();

		// Style
        $this->start_controls_section(
			'progress_bar_style',
			[
				'label' => __( 'Title', 'optech' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' 	=> __( 'Title Color', 'optech' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .progress-title' => 'color: {{VALUE}}',
                ],
			]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'title_typography',
				'label' 	=> __( 'Title Typography', 'optech' ),
                'selector' 	=> '{{WRAPPER}} .progress-title',
			]
		);
		$this->add_control(
			'bar_bg_color',
			[
				'label' 	=> __( 'Bar Bg Color', 'optech' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .progress-content-outter' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'bar_bg_active_color',
			[
				'label' 	=> __( 'Bar Active Bg Color', 'optech' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .progress-content' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'percent_color',
			[
				'label' 	=> __( 'Percent Color', 'optech' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .progress-number-mark' => 'color: {{VALUE}}',
                ],
			]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'percent_typography',
				'label' 	=> __( 'Percent Typography', 'optech' ),
                'selector' 	=> '{{WRAPPER}} .progress-number-mark',
			]
		);
        $this->end_controls_section();

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		?>
			<?php foreach( $settings['progress_bar_repeater'] as $single_data ): ?>
				<div class="optech-progress-item">
					<div class="progress-bar" data-percentage="<?php echo esc_html( $single_data['progress_bar_width']['size'] ); ?>%">
						<div class="progress-title-holder">
							<?php if( ! empty( $single_data['progress_bar_title'] ) ) : ?>
								<div class="progress-title">
									<?php echo esc_html( $single_data['progress_bar_title'] ); ?>
								</div>
							<?php endif; ?>
							<div class="progress-number-wrapper">
								<div class="progress-number-mark">
									<div class="percent"></div>
								</div>
							</div>
						</div>
						<div class="progress-content-outter">
							<div class="progress-content"></div>
						</div>
					</div>
				</div>
			<?php endforeach; ?>
		<?php
	}
}
$widgets_manager->register( new \Optech_Progress_Bar() );