<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Background;
/**
 *
 * Pricing Plan Widget .
 *
 */
class Optech_Pricing_plan extends Widget_Base {

	public function get_name() {
		return 'optechpricingplan';
	}

	public function get_title() {
		return __( 'Pricing Plan', 'optech' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'optech' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'pricing_plan_section',
			[
				'label'		 	=> __( 'Pricing Plans', 'optech' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );
		$this->add_control(
			'pricing_version',
			[
				'label' 		=> __( 'Pricing Style', 'optech' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '1',
				'options' 		=> [
					'1'  			=> __( 'Style One', 'optech' ),
					'2' 			=> __( 'Style Two', 'optech' ),
				],
			]
		);

        $this->add_control(
			'pricing_plan_title',
			[
				'label' 	=> __( 'Title', 'optech' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'Startup', 'optech' ),
				'placeholder' => __( 'Type your title here', 'optech' ),
			]
        );
        $this->add_control(
			'pricing_plan_dec',
			[
				'label' => __( 'Description', 'optech' ),
				'type' => Controls_Manager::TEXTAREA,
				'rows' => 5,
				'default' => __( 'Default description', 'textdomain' ),
				'placeholder' => __( 'Type your description here', 'textdomain' ),
			]
		);

        $this->add_control(
			'pricing_plan_price',
			[
				'label' 	=> __( 'Price', 'optech' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( '$99', 'optech' ),
			]
        );
        $repeater = new Repeater();
		
		$repeater->add_control(
			'pricing_plan_benefit_icon',
			[
				'label' => __( 'Icon', 'optech' ),
				'type' => Controls_Manager::ICONS,
				'default' => [
					'value' => 'remixicon ri-check-line',
					'library' => 'remixicon',
				],
			]
		);
        $repeater->add_control(
			'pricing_plan_benefit',
			[
				'label' => __( 'Benefit', 'optech' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Default Benefit', 'optech' ),
                'placeholder' => __( 'Type your Benefit here', 'optech' ),
			]
		);
		$this->add_control(
			'benefit_repeater',
			[
				'label' 		=> __( 'Benefit Items', 'optech' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' => [
					[
						'pricing_plan_benefit' => __( '10 GB disk space availability', 'optech' ),
					],
					[
						'pricing_plan_benefit' => __( '50 GB NVMe SSD for use', 'optech' ),
					],
					[
						'pricing_plan_benefit' => __( 'Free platform access for all', 'optech' ),
					],
                    [
						'pricing_plan_benefit' => __( 'Free lifetime updates facility', 'optech' ),
					],
                    [
						'pricing_plan_benefit' => __( 'Free one year support', 'optech' ),
					],
				],
				'title_field' => '{{{ pricing_plan_benefit }}}'
			]
		);

        $this->add_control(
			'hr',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

        $this->add_control(
			'pricing_plan_button_text',
			[
				'label' => __( 'Button Text', 'optech' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Select This Plan', 'optech' ),
                'placeholder' => __( 'Type your button text hare', 'optech' ),
			]
		);
        $this->add_control(
			'pricing_plan_button_url',
			[
				'label' => __( 'Button URL', 'optech' ),
				'type' => Controls_Manager::URL,
				'options' => [ 'url', 'is_external', 'nofollow' ],
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				'label_block' => true,
			]
		);

        $this->end_controls_section();

		// Style Section Start
        $this->start_controls_section(
			'pricing_plan_box_style',
			[
				'label' => __( 'Pricing Box', 'optech' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_control(
            'pricing_plan_box_bg_color',
            [
                'label'     => __( 'Background Color', 'optech' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .optech-pricing-wrap' => 'background-color: {{VALUE}}',
                ],
            ]
        );

		$this->add_responsive_control(
			'pricing_plan_box_padding',
			[
				'label'      => __( 'Padding', 'optech' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
                    'top'      => '',
                    'right'    => '',
                    'bottom'   => '',
                    'left'     => '',
                    'unit'     => 'px',
                    'isLinked' => true
                ],
				'selectors'  => [
					'{{WRAPPER}} .optech-pricing-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_responsive_control(
			'pricing_plan_box_margin',
			[
				'label'      => __( 'Margin', 'optech' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
                    'top'      => '',
                    'right'    => '',
                    'bottom'   => '',
                    'left'     => '',
                    'unit'     => 'px',
                    'isLinked' => true
                ],
				'selectors'  => [
					'{{WRAPPER}} .optech-pricing-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'pricing_plan_box_border',
                'label'    => __( 'Border', 'optech' ),
                'selector' => '{{WRAPPER}} .optech-pricing-wrap',
            ]
        );

        $this->add_responsive_control(
            'pricing_plan_box_border_radius',
            [
                'label'      => __( 'Border Radius', 'optech' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default'    => [
                    'top'      => '0',
                    'right'    => '0',
                    'bottom'   => '0',
                    'left'     => '0',
                    'isLinked' => false
                ],
                'selectors'  => [
                    '{{WRAPPER}} .optech-pricing-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
            ]
        );

		$this->end_controls_section();

		//Title
		$this->start_controls_section(
			'pricing_plan_title_style',
			[
				'label' => __( 'Title', 'optech' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'pricing_plan_title_color',
			[
				'label' => __( 'Title Color', 'optech' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-pricing-header h4' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'pricing_plan_title_typography',
				'label' => __( 'Typography', 'optech' ),
				'selector' => '{{WRAPPER}} .optech-pricing-header h4',
			]
		);

		$this->add_responsive_control(
			'pricing_plan_title_padding',
			[
				'label'      => __( 'Padding', 'optech' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
                    'top'      => '0',
                    'right'    => '0',
                    'bottom'   => '0',
                    'left'     => '0',
                    'unit'     => 'px',
                    'isLinked' => true
                ],
				'selectors'  => [
					'{{WRAPPER}} .optech-pricing-header h4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_responsive_control(
			'pricing_plan_title_margin',
			[
				'label'      => __( 'Margin', 'optech' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
                    'top'      => '0',
                    'right'    => '0',
                    'bottom'   => '0',
                    'left'     => '0',
                    'unit'     => 'px',
                    'isLinked' => true
                ],
				'selectors'  => [
					'{{WRAPPER}} .optech-pricing-header h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->end_controls_section();

		//Description
		$this->start_controls_section(
			'pricing_plan_dec_style',
			[
				'label' => __( 'Description', 'optech' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'pricing_plan_dec_color',
			[
				'label' => __( 'Description Color', 'optech' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-pricing-header p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .optech-pricing-wrap p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'pricing_plan_dec_typography',
				'label' => __( 'Typography', 'optech' ),
				'selector' => '{{WRAPPER}} .optech-pricing-header p',
				'selector' => '{{WRAPPER}} .optech-pricing-wrap p',
			]
		);

		$this->add_responsive_control(
			'pricing_plan_dec_padding',
			[
				'label'      => __( 'Padding', 'optech' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
                    'top'      => '0',
                    'right'    => '0',
                    'bottom'   => '0',
                    'left'     => '0',
                    'unit'     => 'px',
                    'isLinked' => true
                ],
				'selectors'  => [
					'{{WRAPPER}} .optech-pricing-header p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .optech-pricing-wrap p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		$this->add_control(
			'pricing_plan_dec_bottom_gap',
			[
				'label' => esc_html__( 'Bottom Gap', 'optech' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .optech-pricing-header' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .optech-pricing-wrap p' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		//price
		$this->start_controls_section(
			'pricing_plan_price_style',
			[
				'label' => __( 'Price', 'optech' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'pricing_plan_price_color',
			[
				'label' => __( 'Price Color', 'optech' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-pricing-price h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'pricing_plan_price_month_color',
			[
				'label' => __( 'Price Month Color', 'optech' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-pricing-price h2 span' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'pricing_plan_price_typography',
				'label' => __( 'Typography', 'optech' ),
				'selector' => '{{WRAPPER}} .optech-pricing-price h2',
			]
		);

		$this->add_responsive_control(
			'pricing_plan_price_padding',
			[
				'label'      => __( 'Padding', 'optech' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
                    'top'      => '',
                    'right'    => '',
                    'bottom'   => '',
                    'left'     => '',
                    'unit'     => 'px',
                    'isLinked' => true
                ],
				'selectors'  => [
					'{{WRAPPER}} .optech-pricing-price h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		$this->add_control(
			'pricing_plan_price_bottom_gap',
			[
				'label' => esc_html__( 'Bottom Gap', 'optech' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .optech-pricing-price' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

		//Benefit
		$this->start_controls_section(
			'pricing_plan_benefit_style',
			[
				'label' => __( 'Benefit Items', 'optech' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'pricing_plan_benefit_color',
			[
				'label' => __( 'Benefit Color', 'optech' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-pricing-feature ul li' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'pricing_plan_benefit_typography',
				'label' => __( 'Benefit Typography', 'optech' ),
				'selector' => '{{WRAPPER}} .optech-pricing-feature ul li',
			]
		);
		$this->add_control(
			'pricing_plan_benefit_icon_color',
			[
				'label' => __( 'Icon Color', 'optech' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-pricing-feature ul li i' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'pricing_plan_benefit_icon_size',
			[
				'label' => esc_html__( 'Icon Size', 'optech' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .optech-pricing-feature ul li i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'pricing_plan_price_benefit_gap',
			[
				'label' => esc_html__( 'Benefit Item Gap', 'optech' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .optech-pricing-feature ul li' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'pricing_plan_benefit_margin',
			[
				'label'      => __( 'Margin', 'optech' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
                    'top'      => '',
                    'right'    => '',
                    'bottom'   => '',
                    'left'     => '',
                    'unit'     => 'px',
                    'isLinked' => true
                ],
				'selectors'  => [
					'{{WRAPPER}} .optech-pricing-feature' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->end_controls_section();

		//Pricing Button
		$this->start_controls_section(
			'pricing_plan_btn_style',
			[
				'label' => __( 'Button', 'optech' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'pricing_plan_btn_color',
			[
				'label' => __( 'Button Color', 'optech' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-pricing-btn' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'pricing_plan_btn_hover_color',
			[
				'label' => __( 'Button Hover Color', 'optech' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-pricing-btn:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'pricing_plan_btn_bg_color',
			[
				'label' => __( 'Background Color', 'optech' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-pricing-btn' => 'background: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'pricing_plan_btn_bg_hover_color',
			[
				'label' => __( 'Background Hover Color', 'optech' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-pricing-btn:hover' => 'background: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'pricing_plan_btn_typography',
				'label' => __( 'Typography', 'optech' ),
				'selector' => '{{WRAPPER}} .optech-pricing-btn',
			]
		);

		$this->add_responsive_control(
			'pricing_plan_btn_padding',
			[
				'label'      => __( 'Padding', 'optech' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
                    'top'      => '',
                    'right'    => '',
                    'bottom'   => '',
                    'left'     => '',
                    'unit'     => 'px',
                    'isLinked' => true
                ],
				'selectors'  => [
					'{{WRAPPER}} .optech-pricing-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		$this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'pricing_plan_btn_border',
                'label'    => __( 'Border Type', 'optech' ),
                'selector' => '{{WRAPPER}} .optech-pricing-btn',
            ]
        );
		$this->add_responsive_control(
            'pricing_plan_btn_border_radius',
            [
                'label'      => __( 'Border Radius', 'optech' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default'    => [
                    'top'      => '6',
                    'right'    => '6',
                    'bottom'   => '6',
                    'left'     => '6',
                    'isLinked' => false
                ],
                'selectors'  => [
                    '{{WRAPPER}} .optech-pricing-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
            ]
        );
		
		$this->end_controls_section();

	}

	protected function render() {
        $settings = $this->get_settings_for_display();

		?>
            <div class="optech-pricing-wrap">
                <div class="optech-pricing-header">
					<h4><?php echo esc_html($settings['pricing_plan_title']); ?></h4>

					<?php if($settings['pricing_version'] == '1') : ?>
						<p><?php echo esc_html($settings['pricing_plan_dec']); ?></p>
					<?php endif; ?>
                </div>
                <div class="optech-pricing-price">
                	<h2><?php echo esc_html($settings['pricing_plan_price']); ?><span>/month</span></h2>
                </div>

				<?php if($settings['pricing_version'] == '2') : ?>
					<p><?php echo esc_html($settings['pricing_plan_dec']); ?></p>
				<?php endif; ?>

				<?php if($settings['pricing_version'] == '2') : ?>
					<a class="optech-pricing-btn" href="<?php echo $settings['pricing_plan_button_url']['url'] ?>">
						<?php echo esc_html($settings['pricing_plan_button_text']); ?>
					</a>
				<?php endif; ?>
                <div class="optech-pricing-feature">
					<ul>
					<?php foreach( $settings['benefit_repeater'] as $single_benefit ): ?>
						<li>
							<?php \Elementor\Icons_Manager::render_icon( $single_benefit['pricing_plan_benefit_icon'], [ 'aria-hidden' => 'true' ] ); ?>
							<?php echo esc_html($single_benefit['pricing_plan_benefit']); ?>
						</li>
					<?php endforeach; ?>
					</ul>
                </div>

				<?php if($settings['pricing_version'] == '1') : ?>
					<a class="optech-pricing-btn" href="<?php echo $settings['pricing_plan_button_url']['url'] ?>">
						<?php echo esc_html($settings['pricing_plan_button_text']); ?>
					</a>
				<?php endif; ?>
            </div>
		<?php
	}
}
$widgets_manager->register( new \Optech_Pricing_plan() );

