<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\HEADING;
use \Elementor\Repeater;
/**
 *
 * Image Widget .
 *
 */
class Optech_IconBox extends Widget_Base {

	public function get_name() {
		return 'optech_iconbox';
	}
 
	public function get_title() {
		return __( 'Optech Iconbox', 'optech' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'optech' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'iconbox_section',
			[
				'label' 	=> __( 'Content', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'box_layout',
			[
				'label' => __( 'Style', 'optech' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'style-one',
				'options' => [
					'style-one'   => __( 'Style 1', 'optech' ),
					'style-two'   => __( 'Style 2', 'optech' ),
					'style-three' => __( 'Style 3', 'optech' ),
					'style-four'  => __( 'Style 4', 'optech' ),
				],
			]
		);
        $this->add_control(
			'image',
			[
				'label'    => __( 'Image', 'optech' ),
				'type'     => Controls_Manager::MEDIA,
				'default'  => [
					'url'   => Utils::get_placeholder_image_src(),
				],
				'condition' =>[
					'box_layout' => ['style-one', 'style-three', 'style-four']
				]
			]
		);	
		$this->add_control(
			'iconbox_icon',
			[
				'label'       => __( 'Icon', 'optech' ),
				'type'        => Controls_Manager::ICONS,
				'label_block' => true,
				'condition' =>[
					'box_layout' => 'style-two'
				]
			]
		);
		$this->add_control(
			'full_box_url',
			[
				'label' => __('URL', 'optech'),
				'type' =>  Controls_Manager::URL,
				'condition' =>[
					'box_layout' => 'style-two'
				]
			]
		);
        $this->add_control(
			'title',
			[
				'label' => __('Title', 'optech'),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __('Highly Expert Team', 'optech')
			]
		);
        
		$this->add_control(
			'description',
			[
				'label' => __('Description', 'optech'),
				'type' => Controls_Manager::TEXTAREA,
				'default' => __('We provide the most responsive and functional IT design', 'optech'),
				'condition' =>[
					'box_layout' => ['style-one', 'style-two', 'style-four']
				]
			]
		);

		$this->add_control(
			'redmore_text',
			[
				'label' => __('Read More Text', 'optech'),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __('Highly Expert Team', 'optech'),
				'condition' =>[
					'box_layout' => [ 'style-four' ]
				]
			]
		);

		$this->add_control(
			'title_url',
			[
				'label' => __('URL', 'optech'),
				'type' =>  Controls_Manager::URL,
				'condition' =>[
					'box_layout' => ['style-one', 'style-four']
				]
			]
		);
		
		$this->end_controls_section();

		// Image style
		$this->start_controls_section(
			'img_style_section',
			[
				'label' 	=> __( 'Image', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
				'condition' =>[
					'box_layout' => ['style-one', 'style-four']
				]
			]
        );
		$this->add_responsive_control(
			'img_box_size',
			[
				'label' 		=> __( 'Image Box Size', 'optech' ),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> [ 'px', '%' ],
				'range' 		=> [
					'px' 			=> [
						'min' 			=> 0,
						'max' 			=> 1000,
						'step'			=> 1,
					],
					'%' 			=> [
						'min' 			=> 0,
						'max' 			=> 100,
						'step'			=> 1,
					],
				],
				'selectors'     => [
					'{{WRAPPER}} .optech-iconbox-icon2' => 'width: {{SIZE}}{{UNIT}};  height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .optech-iconbox-icon4' => 'width: {{SIZE}}{{UNIT}};  height: {{SIZE}}{{UNIT}};',
                ],

			]
		);
		$this->add_control(
			'img_box_bg',
			[
				'label' 	=> __( 'Background Color', 'optech' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-iconbox-icon2' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .optech-iconbox-icon4' => 'background-color: {{VALUE}}',
                ],
			]
        );
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'img_border',
				'label' 	=> __( 'Border', 'optech' ),
                'selector' 	=> '{{WRAPPER}} .optech-iconbox-icon2, {{WRAPPER}} .optech-iconbox-icon4',
			]
		);
		$this->add_responsive_control(
			'img_box_border_radius',
			[
				'label' 		=> __( 'Border Radius', 'optech' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}}  .optech-iconbox-icon2' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}}  .optech-iconbox-icon4' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
		$this->end_controls_section();

		// Icon style
		$this->start_controls_section(
			'icon_style',
			[
				'label' 	=> __( 'Icon', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
				'condition' =>[
					'box_layout' => 'style-two'
				]
			]
        );
		$this->add_control(
			'icon_color',
			[
				'label' 		=> __( 'Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-infobox-icon i, .optech-infobox-icon svg' => 'color: {{VALUE}}',
                ]
			]
        );
		$this->add_responsive_control(
			'icon_size',
			[
				'label' => __( 'Font Size', 'optech' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .optech-infobox-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .optech-infobox-icon svg' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'iconbox_size',
			[
				'label' => __( 'Iconbox Size', 'optech' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .optech-infobox-icon' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'iconbox_bg_color',
			[
				'label' 		=> __( 'Background Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-infobox-icon' => 'background-color: {{VALUE}}',
                ],
			]
        );
		$this->add_responsive_control(
			'iconbox_border_radius',
			[
				'label' 		=> __( 'Border Radius', 'optech' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .optech-infobox-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
		$this->end_controls_section();

		// Title Style
        $this->start_controls_section(
			'title_style_section',
			[
				'label' 	=> __( 'Title', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
			'title_color',
			[
				'label' 		=> __( 'Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-iconbox-data2 h5, .optech-iconbox-data2 h5 a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .optech-infobox-data h5, .optech-infobox-data h5 a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .optech-iconbox-data4 h4' => 'color: {{VALUE}}',
                ]
			]
        );
        $this->add_control(
			'title_hover_color',
			[
				'label' 		=> __( 'Hover Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-iconbox-data2 h5:hover, .optech-iconbox-data2 h5 a:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .optech-infobox-data h5:hover, .optech-infobox-data h5 a:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .optech-iconbox-data4 h4:hover' => 'color: {{VALUE}}',
                ]
			]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __('Title Typography', 'optech'),
				'selector' => '{{WRAPPER}} .optech-iconbox-data2 h5',
				'condition' =>[
					'box_layout' => 'style-one'
				]
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography_stwo',
				'label' => __('Title Typography', 'optech'),
				'selector' => '{{WRAPPER}} .optech-infobox-data h5',
				'condition' =>[
					'box_layout' => 'style-two'
				]
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography_sthree',
				'label' => __('Title Typography', 'optech'),
				'selector' => '{{WRAPPER}} .optech-iconbox-data3 h5',
				'condition' =>[
					'box_layout' => 'style-three'
				]
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography_sfour',
				'label' => __('Title Typography', 'optech'),
				'selector' => '{{WRAPPER}} .optech-iconbox-data4 h4',
				'condition' =>[
					'box_layout' => 'style-four'
				]
			]
		);
        $this->add_responsive_control(
            'title_margin',
            [
                'label'      => __( 'Title margin', 'optech' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .optech-iconbox-data2 h5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .optech-infobox-data h5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .optech-iconbox-data4 h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

		// Text Style
        $this->start_controls_section(
			'text_style_section',
			[
				'label' 	=> __( 'Description', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
			'text_color',
			[
				'label' 		=> __( 'Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-iconbox-data2 p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .optech-infobox-data p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .optech-iconbox-data4 p' => 'color: {{VALUE}}',
                ]
			]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography',
				'label' => __('Typography', 'optech'),
				'selector' => '{{WRAPPER}} .optech-iconbox-data2 p',
				'condition' =>[
					'box_layout' => 'style-one'
				]
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography_stwo',
				'label' => __('Typography', 'optech'),
				'selector' => '{{WRAPPER}} .optech-infobox-data p',
				'condition' =>[
					'box_layout' => 'style-two'
				]
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography_sfour',
				'label' => __('Typography', 'optech'),
				'selector' => '{{WRAPPER}} .optech-iconbox-data4 p',
				'condition' =>[
					'box_layout' => 'style-four'
				]
			]
		);
		$this->add_responsive_control(
            'text_margin',
            [
                'label'      => __( 'Margin', 'optech' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .optech-iconbox-data2 p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .optech-infobox-data p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .optech-iconbox-data4 p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

		// Box Style
        $this->start_controls_section(
			'box_style',
			[
				'label' 	=> __( 'Box', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
		$this->add_control(
			'box_bg_color',
			[
				'label' 		=> __( 'Background Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-infobox-item' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .optech-iconbox-wrap2' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .optech-iconbox-wrap4' => 'background-color: {{VALUE}}',
                ],
			]
        );
		$this->add_responsive_control(
			'box_padding',
			[
				'label' 		=> __( 'Padding', 'optech' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .optech-infobox-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .optech-iconbox-wrap2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .optech-iconbox-wrap4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'border',
				'label' 	=> __( 'Border', 'optech' ),
                'selector' 	=> '{{WRAPPER}} .optech-infobox-item',
                'selector' 	=> '{{WRAPPER}} .optech-iconbox-wrap2',
                'selector' 	=> '{{WRAPPER}} .optech-iconbox-wrap4',
			]
		);
		$this->add_responsive_control(
			'box_border_radius',
			[
				'label' 		=> __( 'Border Radius', 'optech' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .optech-infobox-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .optech-iconbox-wrap2' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .optech-iconbox-wrap4' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
		$this->end_controls_section();


	}

	protected function render() {
        $settings = $this->get_settings_for_display();
        $box_style = $settings['box_layout'];
        $target = isset($settings['title_url']['is_external']) && $settings['title_url']['is_external'] ? 'target="_blank"' : '';
		$nofollow = isset($settings['title_url']['nofollow']) ? ' rel="nofollow"' : '';
		$title_url = !empty($settings['title_url']['url']) ? $settings['title_url']['url'] : '';
		$box_url = !empty($settings['full_box_url']['url']) ? $settings['full_box_url']['url'] : '';

		?>
            <?php
                if ($box_style) {
                    include('iconbox/'.$box_style.'.php');
                }
            ?>
	    <?php
	}
}
$widgets_manager->register( new \Optech_IconBox() );