<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
/**
 *
 * Counter Widget .
 *
 */
class Optech_Counter extends Widget_Base {

	public function get_name() {
		return 'optech_counter';
	}

	public function get_title() {
		return __( 'Counter', 'optech' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'optech' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'counter_section',
			[
				'label' 	=> __( 'Counter', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
			'counter_layout',
			[
				'label' => __( 'Style', 'optech' ),
				'type' => Controls_Manager::SELECT,
				'default' => '',
				'options' => [
					'' =>  __( 'Style 1', 'optech' ),
					'2' => __( 'Style 2', 'optech' ),
					'3' => __( 'Style 3', 'optech' ),
				],
			]
		);


        $this->add_control(
			'counter_bg',
			[
				'label' 	=> __( 'Background Image', 'optech' ),
				'type' 		=> \Elementor\Controls_Manager::MEDIA,
                'condition' =>[
					'counter_layout!' => ['2', '3']
				]
			]
		);
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
			'counter_icon',
			[
				'label' 	=> __( 'Icon', 'optech' ),
				'type' 		=> \Elementor\Controls_Manager::MEDIA,
			]
		);
        $repeater->add_control(
            'percentage_value',
            [
                'label' => __('Percentage Value', 'plugin-name'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [''],
                'default' => [
                    'size' => 50,
                ],
            ]
        );
        $repeater->add_control(
			'counter_suffix',
			[
				'label' => esc_html__( 'Suffix', 'optech' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => esc_html__( '+', 'optech' ),
				'label_block' => true
			]
		);
        $repeater->add_control(
			'counter_title',
			[
				'label' => esc_html__( 'Text', 'optech' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Happy Clients', 'optech' ),
				'label_block' => true
			]
		);
		$this->add_control(
			'counter_list',
			[
				'label' => esc_html__( 'Repeater List', 'optech' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);
        $this->end_controls_section();

        // Box Style
        $this->start_controls_section(
			'box_style',
			[
				'label' => __( 'Box', 'optech' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
                'condition' => [
                    'counter_layout!' => ['2','3']
                ]
			]
		);
        $this->add_control(
			'box_bg_color',
			[
				'label' 		=> __( 'Background Color', 'optech' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-counter-wrap' => 'background-color: {{VALUE}}',
                ],
			]
        );
        $this->add_responsive_control(
			'box_padding',
			[
				'label' => esc_html__( 'Padding', 'optech' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .optech-counter-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);
        $this->add_responsive_control(
			'box_border_radius',
			[
				'label' 		=> __( 'Border Radius', 'optech' ),
				'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .optech-counter-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
        $this->end_controls_section();

        // Icon Style
        $this->start_controls_section(
			'icon_style',
			[
				'label' => __( 'Image', 'optech' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
                'condition' => [
                    'counter_layout!' => ['2']
                ]
			]
		);
        $this->add_responsive_control(
            'icon_size',
            [
                'label'          => __('Size', 'optech'),
                'type'           => \Elementor\Controls_Manager::SLIDER,
                'size_units'     => ['%', 'px','vw'],
                'range'          => [
                    '%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .optech-counter-icon img' => 'width: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .optech-counter-icon3 img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_width',
            [
                'label'          => __('Width', 'optech'),
                'type'           => \Elementor\Controls_Manager::SLIDER,
                'size_units'     => ['%', 'px','vw'],
                'range'          => [
                    '%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .optech-counter-icon' => 'width: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .optech-counter-icon3' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_height',
            [
                'label'          => __('Height', 'optech'),
                'type'           => \Elementor\Controls_Manager::SLIDER,
                'size_units'     => ['px','%', 'vh'],
                'range'          => [
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    '%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'vh' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .optech-counter-icon' => 'height: {{SIZE}}{{UNIT}} !important;',
                    '{{WRAPPER}} .optech-counter-icon3' => 'height: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->add_control(
			'img_box_bg_color',
			[
				'label' 		=> __( 'Background Color', 'optech' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-counter-icon' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .optech-counter-icon3' => 'background-color: {{VALUE}}',
                ],
			]
        );
        $this->add_responsive_control(
			'img_box_border_radius',
			[
				'label' 		=> __( 'Border Radius', 'optech' ),
				'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .optech-counter-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .optech-counter-icon3' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
        $this->end_controls_section();

        // Number Style
        $this->start_controls_section(
			'number_style',
			[
				'label' => __( 'Number', 'optech' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'number_typography',
				'selector' => '{{WRAPPER}} .numbar-style',
			]
		);
		$this->add_control(
			'number_color',
			[
				'label' => esc_html__( 'Color', 'optech' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .numbar-style' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_responsive_control(
			'number_margin',
			[
				'label' => esc_html__( 'Margin', 'optech' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .numbar-style' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);
        $this->end_controls_section();

        // Title Style
        $this->start_controls_section(
			'title_style',
			[
				'label' => __( 'Title', 'optech' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .optech-counter-data p',
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Color', 'optech' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-counter-data p' => 'color: {{VALUE}}',
				],
			]
		);
        $this->end_controls_section(); 

        // Border Style
        $this->start_controls_section(
			'border_style',
			[
				'label' => __( 'Border', 'optech' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
                'condition' =>[
					'counter_layout!' => ['3']
				]
			]
		);
        $this->add_responsive_control(
            'border_width',
            [
                'label'          => __('Width', 'optech'),
                'type'           => \Elementor\Controls_Manager::SLIDER,
                'size_units'     => ['%', 'px','vw'],
                'range'          => [
                    '%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .optech-counter-data::before' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'border_height',
            [
                'label'          => __('Height', 'optech'),
                'type'           => \Elementor\Controls_Manager::SLIDER,
                'size_units'     => ['px','%', 'vh'],
                'range'          => [
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    '%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'vh' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .optech-counter-data::before' => 'height: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->add_control(
			'border_color',
			[
				'label' 		=> __( 'Color', 'optech' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-counter-data::before' => 'background-color: {{VALUE}}',
                ],
			]
        );
        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();
		$counter_list = $settings['counter_list'];
        $img_url = '';

        if( $settings['counter_layout'] == ''  ){
            $img_url = $settings['counter_bg']['url'];
        }else{
            $img_url = '';
        }; 
        
		?>
        <div class="optech-counter-wrap<?php echo esc_attr( $settings['counter_layout'] ); ?> optech-counter-active" style="background-image: url('<?php echo esc_url( $img_url ); ?>')">
            <?php foreach ($counter_list as $counter) : ?>
                <?php if( '' == $settings['counter_layout'] || '2' == $settings['counter_layout']  ): ?>
                    <div class="optech-counter-data" >
                        <?php if (!empty($counter['counter_icon']['url'])) : ?>
                            <div class="optech-counter-icon">
                                <img src="<?php echo esc_url( $counter['counter_icon']['url'] ); ?>" alt="">
                            </div>
                        <?php endif; ?>

                        <div class="optech-counter-number numbar-style">
                            <span data-percentage="<?php echo esc_attr( $counter['percentage_value']['size'] ); ?>" class="optech-counter">
                                <?php echo esc_html( $counter['percentage_value']['size'] ); ?>
                            </span>
                            <?php if( !empty( $counter['counter_suffix'] ) ): ?>
                                <?php echo esc_html($counter['counter_suffix'])?>
                            <?php endif; ?> 
                        </div>
                        <?php if( !empty( $counter['counter_title'] ) ): ?>
                            <p><?php echo esc_html($counter['counter_title'])?></p>
                        <?php endif; ?>
                    </div>
                <?php elseif( '3' == $settings['counter_layout'] ): ?>
                    <div class="optech-counter-data3" >
                        <?php if (!empty($counter['counter_icon']['url'])) : ?>
                            <div class="optech-counter-icon3">
                                <img src="<?php echo esc_url( $counter['counter_icon']['url'] ); ?>" alt="">
                            </div>
                        <?php endif; ?>
                        <div class="optech-counter-right">
                            <div class="optech-counter-number3 numbar-style">
                                <span data-percentage="<?php echo esc_attr( $counter['percentage_value']['size'] ); ?>" class="optech-counter">
                                    <?php echo esc_html( $counter['percentage_value']['size'] ); ?>
                                </span>
                                <?php if( !empty( $counter['counter_suffix'] ) ): ?>
                                    <?php echo esc_html($counter['counter_suffix'])?>
                                <?php endif; ?> 
                            </div>
                            <?php if( !empty( $counter['counter_title'] ) ): ?>
                                <p><?php echo esc_html($counter['counter_title'])?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endforeach; ?>
        </div>
		<?php
	}

}
$widgets_manager->register( new \Optech_Counter() );