<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
/**
 *
 * Button Widget .
 *
 */
class Optech_Button extends Widget_Base {

	public function get_name() {
		return 'optechbutton';
	}

	public function get_title() {
		return __( 'Button', 'optech' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'optech' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'button_section',
			[
				'label' 	=> __( 'Button', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'button_text',
			[
				'label' 	=> __( 'Button Text', 'optech' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Button Text', 'optech' )
			]
        );
        $this->add_control(
			'button_link',
			[
				'label' 		=> __( 'Link', 'optech' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'optech' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);
        $this->add_responsive_control(
			'button_align',
			[
				'label' 		=> __( 'Alignment', 'optech' ),
				'type' 			=> Controls_Manager::CHOOSE,
				'options' 		=> [
					'left' 			=> [
						'title' 		=> __( 'Left', 'optech' ),
						'icon' 			=> 'eicon-text-align-left',
					],
					'center' 		=> [
						'title' 		=> __( 'Center', 'optech' ),
						'icon' 			=> 'eicon-text-align-center',
					],
						'right' 	=> [
						'title' 		=> __( 'Right', 'optech' ),
						'icon' 			=> 'eicon-text-align-right',
					],
				],
				'default' 		=> 'left',
				'toggle' 		=> true,
				'selectors' 	=> [
					'{{WRAPPER}} .btn-wrapper' => 'text-align: {{VALUE}}',
                ],
			]
        );
        $this->end_controls_section();

		// Button Style
        $this->start_controls_section(
			'button_style_section',
			[
				'label' 	=> __( 'Button Style', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
			'button_color',
			[
				'label' 		=> __( 'Button Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-default-btn' => 'color: {{VALUE}} !important',
                ],
			]
        );
        $this->add_control(
			'button_color_hover',
			[
				'label' 		=> __( 'Button Color Hover', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-default-btn::after, .optech-default-btn:hover' => 'color: {{VALUE}} !important',
                ],
			]
        );
        $this->add_control(
			'button_bg_color',
			[
				'label' 		=> __( 'Background Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-default-btn' => 'background-color: {{VALUE}} !important',
                ],
			]
        );
        $this->add_control(
			'button_bg_color_hover',
			[
				'label' 		=> __( 'Background Hover Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-default-btn::before' => 'background-color: {{VALUE}} !important',
                ],
			]
        );
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'button_typography',
				'label' 	=> __( 'Button Typography', 'optech' ),
                'selector' 	=> '{{WRAPPER}} .optech-default-btn',
			]
        );
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'border',
				'label' 	=> __( 'Border', 'optech' ),
                'selector' 	=> '{{WRAPPER}} .optech-default-btn',
			]
		);
        $this->add_responsive_control(
			'button_padding',
			[
				'label' 		=> __( 'Button Padding', 'optech' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [ 
					'{{WRAPPER}} .optech-default-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
        $this->add_responsive_control(
			'button_border_radius',
			[
				'label' 		=> __( 'Button Border Radius', 'optech' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .optech-default-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' 		=> 'box_shadow',
				'label' 	=> __( 'Box Shadow', 'optech' ),
				'selector' 	=> '{{WRAPPER}} .optech-default-btn',
			]
		);
        $this->end_controls_section();

    }
	

	protected function render() {

        $settings = $this->get_settings_for_display();

		$noflow =  $settings['button_link']['nofollow'] ? 'rel="nofollow"' : '';
		$target = $settings['button_link']['is_external'] ? 'target="_blank"' : ''; 
		$url = $settings['button_link']['url']; 

        
		?>	
			<?php if( !empty( $settings['button_text'] ) ): ?>
				<a class="optech-default-btn btn-style" href="<?php echo esc_url( $url ); ?>" <?php echo esc_attr( $target ); ?> <?php echo esc_attr( $noflow ); ?> data-text="<?php echo esc_html($settings['button_text']); ?>">
					<span class="btn-wraper">
						<?php echo esc_html($settings['button_text']); ?>
					</span>
				</a>
			<?php endif; ?>
		<?php
	}

}
$widgets_manager->register( new \Optech_Button() );