<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Utils;
/**
 *
 * Button Widget .
 *
 */
class Optech_Blog_Post extends Widget_Base {

	public function get_name() {
		return 'optech_blog_post';
	}

	public function get_title() {
		return __( 'Blog Post', 'optech' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'optech' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'blog_settings',
			[
				'label' 	=> __( 'Blog Settings', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
		$this->add_control(
			'blog_layout',
			[
				'label' => __( 'Layout', 'optech' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'style-one',
				'options' => [
					'style-one' => __( 'Style 1', 'optech' ),
					'style-two' => __( 'Style 2', 'optech' ),
					'style-three' => __( 'Style 3', 'optech' ),
				],
			]
		);
		$this->add_responsive_control('per_line', [
            'label'              => __('Columns per row', 'optech'),
            'type'               => Controls_Manager::SELECT,
            'default'            => '3',
            'tablet_default'     => '6',
            'mobile_default'     => '12',
            'options'            => [
                '12' => '1',
                '6'  => '2',
                '4'  => '3',
                '3'  => '4',
            ],
            'frontend_available' => true,
        ]);
		$this->add_control(
            'blog_per_page',
            [
                'label'       => __('Numbar Of Post', 'optech'),
                'type'        => Controls_Manager::NUMBER,
                'default'     => '',
                'description' => 'use empty value show all posts',
            ]
        );
		$this->add_control(
            'post_by',
            [
                'label' => __('Post By:', 'optech'),
                'type' => Controls_Manager::SELECT,
                'default' => 'latest',
                'label_block' => true,
                'options' => array(
                    'latest'   =>   __('Latest Post', 'optech'),
                    'selected' =>   __('Selected posts', 'optech'),
                ),
            ]
        );
        $this->add_control(
            'post__in',
            [
                'label' => __('Post In', 'optech'),
                'type' => Controls_Manager::SELECT2,
                'options' => optech_get_all_posts('post'),
                'multiple' => true,
                'label_block' => true,
                'condition'   => [
					'post_by' => 'selected',
				]
            ]
        );
        $this->add_control(
            'orderby',
            [
                'label' => __('Order By', 'optech'),
                'type' => Controls_Manager::SELECT,
                'options' => optech_get_post_orderby_options(),
                'default' => 'date',
                'label_block' => true,

            ]
        );
        $this->add_control(
            'order',
            [
                'label' => __('Order', 'optech'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'asc' => 'Ascending',
                    'desc' => 'Descending',
                ],
                'default' => 'desc',
                'label_block' => true,

            ]
        );
        $this->end_controls_section();

		// Blog Content
		$this->start_controls_section(
			'blog_content',
			[
				'label' 	=> __( 'Blog Content', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
		$this->add_control(
            'show_date',
            [
                'label' => __( 'Date?', 'optech' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'optech' ),
                'label_off' => __( 'Hide', 'optech' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
		$this->add_control(
            'show_excerpt',
            [
                'label' => __( 'Show Excerpt', 'optech' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'optech' ),
                'label_off' => __( 'Hide', 'optech' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
		$this->add_control(
            'excerpt_limit',
            [
                'label' => __('Excerpt Word Limit', 'optech'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 15,
                ],
                'devices' => ['desktop', 'tablet', 'mobile'],
                'condition' => [
                    'show_excerpt' => 'yes',
                ]
            ]
        );
		$this->add_control(
            'show_btn',
            [
                'label' => __( 'Show Button', 'optech' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'optech' ),
                'label_off' => __( 'Hide', 'optech' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
		$this->add_control(
			'button_text',
			[
				'label' 	=> __( 'Button Text', 'optech' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'More Details', 'optech' ),
				'condition'   => [
					'show_btn' => 'yes',
				]
			]
        );
		
		  $this->add_control(
            'enable_pagination',
            [
                'label' => __('Show Pagination?', 'grayic-ts'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'grayic-ts'),
                'label_off' => __('No', 'grayic-ts'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
		
        $this->end_controls_section();

		// Image Style
        $this->start_controls_section(
			'img_style',
			[
				'label' 	=> __( 'Image', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
		$this->add_responsive_control(
			'img_height',
			[
				'label' 		=> __( 'Height', 'optech' ),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> [ 'px', '%' ],
				'range' 		=> [
					'px' 			=> [
						'min' 			=> 0,
						'max' 			=> 1000,
						'step'			=> 1,
					],
					'%' 			=> [
						'min' 			=> 0,
						'max' 			=> 100,
						'step'			=> 1,
					],
				],
				'selectors'     => [
					'{{WRAPPER}} .blog-img img' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .optech-blog-thumb2' => 'height: {{SIZE}}{{UNIT}};',
                ],

			]
		);
		$this->add_responsive_control(
			'img_border_radius',
			[
				'label' 		=> __( 'Image Border Radius', 'optech' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .blog-img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
				
			]
		);
        $this->end_controls_section();

		// Box Style
        $this->start_controls_section(
			'box_style',
			[
				'label' 	=> __( 'Box', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
		$this->add_control(
			'box_bg_color',
			[
				'label' 		=> __( 'Box bg Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .blog-single' => 'background-color: {{VALUE}}',
                ],
				'condition' => [
					'blog_layout!' => ['style-two']
				]
			]
        );
		$this->add_responsive_control(
			'box_padding',
			[
				'label' 		=> __( 'Padding', 'optech' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .blog-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .optech-blog-content2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
		);
		$this->add_responsive_control(
			'box_margin',
			[
				'label' 		=> __( 'Margin', 'optech' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .blog-single' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .optech-blog-wrap2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'box_border',
				'label' 	=> __( 'Border', 'optech' ),
                'selector' 	=> '{{WRAPPER}} .blog-single',
				'condition' => [
					'blog_layout!' => ['style-two']
				]
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'box_hover_border',
				'label' 	=> __( 'Hover Border', 'optech' ),
                'selector' 	=> '{{WRAPPER}} .blog-single:hover',
				'condition' => [
					'blog_layout!' => ['style-two']
				]
			]
		);
		$this->add_responsive_control(
			'box_border_radius',
			[
				'label' 		=> __( 'Border Radius', 'optech' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .blog-single' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
				'condition' => [
					'blog_layout!' => ['style-two']
				]
			]
		);
        $this->end_controls_section();

		// Meta Style
        $this->start_controls_section(
			'meta_style',
			[
				'label' 	=> __( 'Meta', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
		$this->add_control(
			'meta_color',
			[
				'label' 		=> __( 'Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .blog-meta a' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .blog-meta a::before' => 'background-color: {{VALUE}} !important',
                ]
			]
        );
		$this->add_control(
			'meta_hover_color',
			[
				'label' 		=> __( 'Hover Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .blog-meta a:hover' => 'color: {{VALUE}}',
                ]
			]
        );
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'meta_typography',
				'label' => __('Typography', 'optech'),
				'selector' => '{{WRAPPER}} .blog-meta a',
			]
		);
        $this->end_controls_section();

		// Title Style
        $this->start_controls_section(
			'title_style',
			[
				'label' 	=> __( 'Title', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
		$this->add_control(
			'title_color',
			[
				'label' 		=> __( 'Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .blog-title-sm a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .optech-blog-content2 h4' => 'color: {{VALUE}}',
                ]
			]
        );
		$this->add_control(
			'title_hover_color',
			[
				'label' 		=> __( 'Hover Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .blog-title-sm a:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .optech-blog-content2 a:hover' => 'color: {{VALUE}}',
                ]
			]
        );
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __('Typography', 'optech'),
				'selector' => '{{WRAPPER}} .blog-title-sm',
				'condition'   => [
					'blog_layout' => ['style-one'],
				]
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_two_typography',
				'label' => __('Typography', 'optech'),
				'selector' => '{{WRAPPER}} .optech-blog-content2 h4',
				'condition'   => [
					'blog_layout' => 'style-two',
				]
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_three_typography',
				'label' => __('Typography', 'optech'),
				'selector' => '{{WRAPPER}} .optech-blog-content2 h4',
				'condition'   => [
					'blog_layout' => 'style-three',
				]
			]
		);

		$this->add_responsive_control(
			'title_margin',
			[
				'label' 		=> __( 'Margin', 'optech' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}}  .blog-title-sm' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}}  .optech-blog-content2 h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->end_controls_section();

		// Text Style
        $this->start_controls_section(
			'text_style',
			[
				'label' 	=> __( 'Excerpt', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
				'condition'   => [
					'show_excerpt' => 'yes',
				]
			]
        );
		$this->add_control(
			'text_color',
			[
				'label' 		=> __( 'Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-excerpt p' => 'color: {{VALUE}}',
                ]
			]
        );
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography',
				'label' => __('Typography', 'optech'),
				'selector' => '{{WRAPPER}} .optech-excerpt p',
			]
		);
		$this->add_responsive_control(
			'text_margin',
			[
				'label' 		=> __( 'Margin', 'optech' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}}  .optech-excerpt p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->end_controls_section();

		// Button Style
        $this->start_controls_section(
			'btn_style',
			[
				'label' 	=> __( 'Button', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
		$this->add_control(
			'button_color',
			[
				'label' 		=> __( 'Button Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-icon-btn' => 'color: {{VALUE}}',
                ]
			]
        );
        $this->add_control(
			'button_color_hover',
			[
				'label' 		=> __( 'Button Color Hover', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-icon-btn:hover' => 'color: {{VALUE}}',
                ]
			]
        );
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'button_typography',
				'label' 	=> __( 'Typography', 'optech' ),
                'selector' 	=> '{{WRAPPER}} .optech-icon-btn',
			]
        );
		$this->add_control(
			'icon_color',
			[
				'label' 		=> __( 'Icon Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-icon-btn i' => 'color: {{VALUE}}',
                ]
			]
        );
		$this->add_control(
			'icon_size',
			[
				'label' => esc_html__( 'Size', 'optech' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 30,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .optech-icon-btn i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->end_controls_section();
		
		$this->start_controls_section(
            'section_pagination',
            [
                'label' => __('Pagination', 'optech'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'enable_pagination' => 'yes',
                ]
            ]
        );
        $this->start_controls_tabs(
            'pagination_controls'
        );
        $this->start_controls_tab(
            'pagination_normal',
            [
                'label' => __('Normal', 'optech'),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => __('Pagination typography', 'optech'),
                'name' => 'pagi_typography',
                'selector' => '{{WRAPPER}} .optech-pagination  a, {{WRAPPER}} .optech-pagination span',
            ]
        );
        $this->add_control(
            'pagi_color',
            [
                'label' => __('Pagination Color', 'optech'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .optech-pagination > a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .optech-pagination > span ' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .optech-pagination a span.optech-pagination-icon ' => 'color: {{VALUE}}',
                ],

            ]
        );
		$this->add_control(
			'pagi_width_height',
			[
				'label' => esc_html__( 'Width & Height', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 60,
				],
				'selectors' => [
					'{{WRAPPER}} .optech-pagination > a,.optech-pagination > span' => 'width: {{SIZE}}{{UNIT}};height:{{SIZE}}{{UNIT}};',
				],
			]
		);
		
		
        $this->add_control(
            'pagi_bg_color',
            [
                'label' => __('Pagination Background Color', 'optech'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .optech-pagination > a' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .optech-pagination > span ' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .optech-pagination a span.optech-pagination-icon' => 'background-color: {{VALUE}}',
                ],

            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'page_border',
                'label' => __('Pagination Border', 'optech'),
                'selector' => '{{WRAPPER}} .optech-pagination > a, {{WRAPPER}} .optech-pagination > span',

            ]
        );
        $this->add_control(
            'hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_responsive_control(
            'pagi_align',
            [
                'label' => __('Align', 'optech'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'start' => [
                        'title' => __('Left', 'optech'),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'optech'),
                        'icon' => 'fa fa-align-center',
                    ],
                    'end' => [
                        'title' => __('Right', 'optech'),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .optech-pagination'    => 'justify-content: {{VALUE}};',
                ],
                'devices' => ['desktop', 'tablet', 'mobile'],
                'toggle' => true,
            ]
        );
        $this->add_responsive_control(
            'pagi_margin',
            [
                'label' => __('Pagination Margin', 'optech'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .optech-pagination'    => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} optech-pagination' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );
        $this->add_responsive_control(
            'pagi_radius',
            [
                'label' => __('Pagination Border Radius', 'optech'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .optech-pagination > a'    => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .optech-pagination > span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'pagination_hover',
            [
                'label' => __('Hover', 'optech'),

            ]
        );
        $this->add_control(
            'pagi_hover_color',
            [
                'label' => __('Pagination Hover Color', 'optech'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .optech-pagination > a:hover' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .optech-pagination > span:hover ' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .optech-pagination > span.current ' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .optech-pagination a:hover span.optech-pagination-icon ' => 'color: {{VALUE}}',
                ],

            ]
        );
        $this->add_control(
            'pagi_hover_bg_color',
            [
                'label' => __('Pagination Background Hover Color', 'optech'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .optech-pagination > a:hover' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .optech-pagination > span:hover ' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .optech-pagination > span.current ' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .optech-pagination a:hover span.optech-pagination-icon' => 'background-color: {{VALUE}}',
                ],

            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'page_hover_border',
                'label' => __('Pagination Hover Border', 'optech'),
                'selector' => '{{WRAPPER}} .optech-pagination > a:hover, {{WRAPPER}} .optech-pagination > span:hover,{{WRAPPER}} .optech-pagination > span.current',
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

		$grid_classes = [];
		$grid_classes[] = 'col-xl-' . $settings['per_line'];
		$grid_classes[] = 'col-md-' . $settings['per_line_tablet'];
		$grid_classes[] = 'col-sm-' . $settings['per_line_mobile'];
		$grid_classes = implode(' ', $grid_classes);
		$this->add_render_attribute('blog_gride_classes', 'class', [$grid_classes]);


        ?>

		<?php
		// Query
		$numabr_of_post = !empty($settings['blog_per_page']) ? $settings['blog_per_page'] : -1;
		$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

		$query_args = [
			'post_type'           => 'post',
			'orderby' => $settings['orderby'],
			'order'   => $settings['order'],
			'posts_per_page'      => $numabr_of_post,
			'post_status'         => 'publish',
			'ignore_sticky_posts' => 1,
			'paged' => $paged
		];

		// get_type
		if ( 'selected' === $settings['post_by'] ) {
			$query_args['post__in'] = (array)$settings['post__in'];
		}

		$the_query = new \WP_Query($query_args);

        $blog_style = $settings['blog_layout'];

		?>
			<?php
                if ($blog_style) {
                    include('blog/'.$blog_style.'.php');
                }
            ?>

		<?php
		if ('yes' === $settings['enable_pagination']) :
            $big = 999999999; // need an unlikely integer
            echo '<div class="row"><div class="col-12"><div class="optech-pagination">';
            echo paginate_links(array(
                'base' => str_replace($big, '%#%', get_pagenum_link($big)),
                'format' => '?paged=%#%',
                'current' => max(1, get_query_var('paged')),
                'prev_text' => '<i class="fas fa-angle-left"> </i>',
                'next_text' => '<i class="fas fa-angle-right"> </i>',
                'total' => $the_query->max_num_pages,
            ));
            echo '</div></div></div>';
        endif;

	}

}
$widgets_manager->register( new \Optech_Blog_Post() );