<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
/**
 *
 * Mobilemenu Widget .
 *
 */
class Optech_Offcanvas extends Widget_Base {

	public function get_name() {
		return 'optechoffcanvas';
	}

	public function get_title() {
		return __( 'Offcanvas', 'optech' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'optech_header_elements' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'offcanvas_section',
			[
				'label' 	=> __( 'Offcanvas', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'optech_Offcanvas_builder',
			[
				'label'     => __( 'Select Offcanvas', 'optech' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => $this->optech_offcanvas_one(),
				'default'	=> ''
			]
		);


		$this->add_control(
			'icon_color',
			[
				'label' 		=> __( 'Icon Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .simple-icon' => 'color: {{VALUE}}',
                ],
			]
        );

		$this->add_control(
			'icon_hover_color',
			[
				'label' 		=> __( 'Icon Hover Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .simple-icon:hover' => 'color: {{VALUE}}',
                ],
			]
        );

		$this->add_control(
			'icon_bg_color',
			[
				'label' 		=> __( 'Icon Background Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .simple-icon' => 'background-color: {{VALUE}}',
                ],
			]
        );

		$this->add_control(
			'icon_bg_hover_color',
			[
				'label' 		=> __( 'Icon Background Hover Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .simple-icon:hover' => 'background-color: {{VALUE}}',
                ],
			]
        );

		$this->add_control(
			'offcanvas_bg_color',
			[
				'label' 		=> __( 'Offcanvas Background Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .sidemenu-wrapper .sidemenu-content' => 'background-color: {{VALUE}}',
                ],
			]
        );

        $this->end_controls_section();

    }


	public function optech_offcanvas_one(){

		$optech_post_query = new WP_Query( array(
			'post_type'				=> 'optech_off_build',
			'posts_per_page'	    => -1,
		) );

		$optech_tab_builder_title_title = array();
		$optech_tab_builder_title_title[''] = __( 'Select a Title','optech');

		while( $optech_post_query->have_posts() ) {
			$optech_post_query->the_post();
			$optech_tab_builder_title_title[ get_the_ID() ] =  get_the_title();
		}
		wp_reset_postdata();
		return $optech_tab_builder_title_title;
	}

	protected function render() {

        $settings = $this->get_settings_for_display();


		echo '<div class="optech-header-barger">';
			echo '<span></span>';
		echo '</div>';
	
		echo '<div class="optech-sidemenu-wraper">';
			echo '<div class="optech-sidemenu-column ">';
				echo '<div class="optech-sidemenu-body">';
					$elementor = \Elementor\Plugin::instance();
					echo $elementor->frontend->get_builder_content_for_display($settings['optech_Offcanvas_builder']);
				echo '</div>';
				echo '<span class="optech-sidemenu-close"><i class="ri-close-line"></i></span>';
			echo '</div>';
			echo '<div class="offcanvas-overlay "></div>';
		echo '</div>';

	}
}
$widgets_manager->register( new \Optech_Offcanvas() );

