<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Image_Size;
/**
 *
 * Mobilemenu Widget .
 *
 */
class Mirror_Menu extends Widget_Base {

	public function get_name() {
		return 'mirrormenu';
	}

	public function get_title() {
		return __( 'Mirror Menu', 'optech' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'optech_header_elements' ];
	}

	private function get_available_menus() {

        $menus = wp_get_nav_menus();

        $options = [];

        foreach ( $menus as $menu ) {

            $options[$menu->slug] = $menu->name;

        }

        return $options;

    }

	protected function register_controls() {

		$this->start_controls_section(
			'mobile_menu_section',
			[
				'label' 	=> __( 'Mirror Menu', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
		$this->add_control(
			'logo_type',
			[
				'label' => __( 'Logo Type', 'optech' ),
				'type'  => Controls_Manager::SELECT,
				'default' => 'dark',
				'options' => [
					'dark'   => __( 'Dark', 'optech' ),
					'white'  => __( 'White', 'optech' ),
					'custom' => __( 'Custom', 'optech' ),
				],
			]
        );
		$this->add_control(
            'image',
            [
                'label' => __('Choose logo', 'optech'),
                'type'  => Controls_Manager::MEDIA,
                'default' => [
                    'url' => '',
                ],
                'condition' => [
                    'logo_type' => 'custom',
                ]
            ]
        );
        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name'    => 'logo_size', 
                'include' => [],
                'default' => 'large',
                'condition' => [
                    'logo_type' => 'custom',
                ]
            ]
        );
		$this->add_control(
			'menu_bg_color',
			[
				'label' 		=> __( 'Menu Background Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .main-menu ul' => 'background-color: {{VALUE}}',
                ],
			]
        );
		$this->add_control(
			'mibile_menu_align',
			[
				'label' 	=> __( 'Menu Alignment', 'optech' ),
				'type' 		=> Controls_Manager::CHOOSE,
				'options' 	=> [
					'left' 		=> [
						'title' 	=> __( 'Left', 'optech' ),
						'icon' 		=> 'fa fa-align-left',
					],
					'center' 	=> [
						'title' 	=> __( 'Center', 'optech' ),
						'icon' 		=> 'fa fa-align-center',
					],
					'right' 	=> [
						'title' 	=> __( 'Right', 'optech' ),
						'icon' 		=> 'fa fa-align-right',
					],
				],
				'selectors' 	=> [
					'{{WRAPPER}} .main-menu ul' => 'text-align: {{VALUE}} !important;',
				],
				'toggle' 		=> true,
			]
		);
		$this->add_control(
            'use_main_menu',
            [
                'label'        => __( 'Use Main Menu', 'optech' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Yes', 'optech' ),
                'label_off'    => __( 'No', 'optech' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );
        $menus = $this->get_available_menus();

        if ( !empty( $menus ) ) {
            $this->add_control(
                'primary_menu',
                [
                    'label'        => __( 'Menu', 'header-footer-elementor' ),
                    'type'         => Controls_Manager::SELECT,
                    'options'      => $menus,
                    'default'      => array_keys( $menus )[0],
                    'save_default' => true,
                    'separator'    => 'after',
                    'description'  => sprintf( __( 'Go to the <a href="%s" target="_blank">Menus screen</a> to manage your menus.', 'header-footer-elementor' ), admin_url( 'nav-menus.php' ) ),
                    'condition'    => [
                        'use_main_menu!' => 'yes',
                    ],
                ]
            );
        } else {
            $this->add_control(
                'menu',
                [
                    'type'            => Controls_Manager::RAW_HTML,
                    'raw'             => sprintf( __( '<strong>There are no menus in your site.</strong><br>Go to the <a href="%s" target="_blank">Menus screen</a> to create one.', 'header-footer-elementor' ), admin_url( 'nav-menus.php?action=edit&menu=0' ) ),
                    'separator'       => 'after',
                    'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
                ]
            );
        }
        $this->end_controls_section();

        // Menu style
        $this->start_controls_section(
			'menu_style',
			[
				'label' 	=> __( 'Menu', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
			'menu_color',
			[
				'label' 		=> __( 'Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .main-menu a' => 'color: {{VALUE}}',
                ]
			]
        );
        $this->add_control(
			'menu_hover_color',
			[
				'label' 		=> __( 'Hover Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .main-menu > ul > li > a:hover' => 'color: {{VALUE}}',
                ]
			]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'menu_typography',
				'label' => __('Typography', 'optech'),
				'selector' => '{{WRAPPER}} .main-menu a',
			]
		);
        $this->add_responsive_control(
			'menu_padding',
			[
				'label' 		=> __( 'Padding', 'optech' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .main-menu > ul > li > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
        $this->add_responsive_control(
			'menu_margin',
			[
				'label' 		=> __( 'Margin', 'optech' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .main-menu > ul > li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
        $this->end_controls_section();

        // Sub Menu style
        $this->start_controls_section(
			'sub_menu_style',
			[
				'label' 	=> __( 'Sub Menu', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
			'sub_menu_color',
			[
				'label' 		=> __( 'Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .main-menu ul.sub-menu li a' => 'color: {{VALUE}} !important',
                ]
			]
        );
        $this->add_control(
			'sub_menu_hover_color',
			[
				'label' 		=> __( 'Hover Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .main-menu ul.sub-menu li a:hover' => 'color: {{VALUE}}',
                ]
			]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'sub_menu_typography',
				'label' => __('Typography', 'optech'),
				'selector' => '{{WRAPPER}} .main-menu ul.sub-menu li a',
			]
		);
        $this->add_responsive_control(
			'submenu_padding',
			[
				'label' 		=> __( 'Padding', 'optech' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .main-menu ul.sub-menu li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
        $this->end_controls_section();


        // Button style
        $this->start_controls_section(
			'button_style',
			[
				'label' 	=> __( 'Button', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
			'button_color',
			[
				'label' 		=> __( 'Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .button-one' => 'color: {{VALUE}} !important',
                ]
			]
        );
        $this->add_control(
			'button_bg_color',
			[
				'label' 		=> __( 'Background Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .button-one' => 'background-color: {{VALUE}} !important',
                ]
			]
        );
        $this->add_control(
			'button_hover_color',
			[
				'label' 		=> __( 'Hover Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .button-one:hover' => 'color: {{VALUE}}',
                ]
			]
        );
        $this->add_control(
			'button_hover_bgcolor',
			[
				'label' 		=> __( 'Background Hover Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .button-one:hover' => 'background-color: {{VALUE}}',
                ]
			]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'button_typography',
				'label' => __('Typography', 'optech'),
				'selector' => '{{WRAPPER}} .button-one',
			]
		);
        $this->add_responsive_control(
			'button_padding',
			[
				'label' 		=> __( 'Padding', 'optech' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .button-one' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

		$this->add_responsive_control(
			'button_border_one_radius',
			[
				'label' 		=> __( 'Border Radius', 'optech' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .button-one' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
        $this->end_controls_section();


        //   Button Style two
        $this->start_controls_section(
			'button_two_style',
			[
				'label' 	=> __( 'Button Two', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
			'button_two_color',
			[
				'label' 		=> __( 'Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .button-two' => 'color: {{VALUE}} !important',
                ]
			]
        );
        $this->add_control(
			'button_two_bg_color',
			[
				'label' 		=> __( 'Background Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .button-two' => 'background-color: {{VALUE}} !important',
                ]
			]
        );
        $this->add_control(
			'button_two_hover_color',
			[
				'label' 		=> __( 'Hover Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .button-two:hover' => 'color: {{VALUE}}',
                ]
			]
        );
        $this->add_control(
			'button_two_hover_bgcolor',
			[
				'label' 		=> __( 'Background Hover Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .button-two:hover' => 'background-color: {{VALUE}}',
                ]
			]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'button_two_typography',
				'label' => __('Typography', 'optech'),
				'selector' => '{{WRAPPER}} .button-two',
			]
		);
        $this->add_responsive_control(
			'button_two_padding',
			[
				'label' 		=> __( 'Padding', 'optech' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .button-two' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

        $this->add_responsive_control(
			'button_border_two_radius',
			[
				'label' 		=> __( 'Border Radius', 'optech' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .button-two' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
        $this->end_controls_section();

		 // Button Content
		 $this->start_controls_section(
			'button_content',
			[
				'label' 	=> __( 'Button', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'btn_one',
			[
				'label' => esc_html__( 'Button Text', 'optech' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'contact us', 'optech' ),
				'label_block' => true
			]
		);
		$this->add_control(
			'btn_one_link',
			[
				'label' 		=> __( 'Button One Link', 'optech' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'optech' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);

		$this->add_control(
			'btn_two',
			[
				'label' => esc_html__( 'Button Text Two', 'optech' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Learn More', 'optech' ),
				'label_block' => true
			]
		);

		$this->add_control(
			'btn_two_link',
			[
				'label' 		=> __( 'Button Two Link', 'optech' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'optech' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);
        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

		if ( 'yes' == $settings['use_main_menu'] ) {
            $args = [
                'theme_location'  => 'primary-menu',
                'container'      => false, 
                'menu_id'        => false, 
                'menu_class'     => false, 
            ];
        } else {
            $args = [
                // 'theme_location'        => 'main-menu',
                'menu'            => $settings['primary_menu'],
                'container'      => false, 
                'menu_id'        => false, 
                'menu_class'     => false, 
            ];
        }

		if( has_nav_menu( 'primary-menu' ) ){
			?>
			<div class="mirror-main-wraper"> 
				<div class="mirror-menu-wrapper"> 
					<div class="mirror-menu-area text-center">
						<div class="mirror-menu-mobile-top">
							<div class="mobile-logo">
								<a href="<?php echo home_url(); ?>">
									<?php
										if ( 'custom' == $settings['logo_type'] && $settings['image']['url']) {
											echo Group_Control_Image_Size::get_attachment_image_html($settings, 'thumbnail', 'image');
										} else {
											echo $this->optech_get_site_logo( $settings['logo_type'] );
										}
									?>
								</a>
							</div>
							<button class="mirror-menu-toggle mobile">
								<i class="ri-close-line"></i>
							</button>
						</div>

						<div class="mirror-mobile-menu">
							<?php wp_nav_menu( $args );?>
						</div>
						<div class="mirror-mobile-menu-btn">
							<?php if( $settings['btn_one'] ): ?>
								<a class="mirror-default-btn button-one" href="<?php echo esc_url( $settings['btn_one_link']['url'] ) ?>">
									<?php echo esc_html( $settings['btn_one'] ); ?>
								</a>
							<?php endif; ?>

							<?php if( $settings['btn_two'] ): ?>
								<a class="mirror-default-btn button-two" href="<?php echo esc_url( $settings['btn_two_link']['url'] ) ?>">
									<?php echo esc_html( $settings['btn_two'] ); ?>
								</a>
							<?php endif; ?>
						</div>
					</div>
				</div>
				
				<nav class="main-menu menu-style1">
					<?php wp_nav_menu( $args );?>
				</nav>
				<!-- mobile menu trigger -->
				<button class="mirror-menu-toggle">
					<i class="ri-menu-line"></i>
				</button>
				<!--/.Mobile Menu Hamburger Ends-->
			</div>
          <?php 
		}
	}

	/**
     * 
     *  optech get logo  
     * 
     */
    public function optech_get_site_logo( $logo_type = 'dark'  ) {
        $logo = '';
        $optech = get_option('optech_opt');
        $logo_url = '';
        if ( 'dark' ==  $logo_type && isset( $optech['dark_logo']['url'] ) ) {
            $logo_url = esc_url($optech['dark_logo']['url']);
            $logo = '<img src="' . esc_url($logo_url) . '" alt="' . esc_attr(get_bloginfo('title')) . '">';

        } else if ( 'white' ==  $logo_type && isset($optech['white_logo']['url'])) {
            $logo_url = esc_url($optech['white_logo']['url']);
            $logo = '<img src="' . esc_url($logo_url) . '" alt="' . esc_attr(get_bloginfo('title')) . '">';
        } else {
            if ( has_custom_logo() ) {
                $core_logo_id = get_theme_mod('custom_logo');
                $logo_url = wp_get_attachment_image_src($core_logo_id, 'full');
                $logo = '<img src="' . esc_url($logo_url[0]) . '" alt="' . esc_attr(get_bloginfo('title')) . '">';
            } else {
                $logo = '<h3>' . get_bloginfo('name') . '</h3>';
            }
        }
        return $logo;
    }
}
$widgets_manager->register( new \Mirror_Menu() );