<?php
// File Security Check
if (!defined('ABSPATH')) {
	exit;
}
class OptechCustomPosts{

    function __construct()
	{   
        /*----------  Service ----------*/
        add_action('init', array($this, 'optech_service'));


        /*----------  Team ----------*/
        add_action('init', array($this, 'optech_team'));

        /*----------  Project ----------*/
        add_action('init', array($this, 'optech_project'));
        add_action('init', array($this, 'optech_project_category'));
    }

    /*----------  Service ----------*/   
    public function optech_service() 
    {
        $labels = array(
            'name'               => esc_html__( 'Services', 'Service general name', 'optech' ),
            'singular_name'      => esc_html__( 'Service', 'Service singular name', 'optech' ),
            'menu_name'          => esc_html__( 'Services', 'admin menu', 'optech' ),
            'name_admin_bar'     => esc_html__( 'Service', 'add new on admin bar', 'optech' ),
            'add_new'            => esc_html__( 'Add New', 'Service', 'optech' ),
            'add_new_item'       => esc_html__( 'Add New Service', 'optech' ),
            'new_item'           => esc_html__( 'New Service', 'optech' ),
            'edit_item'          => esc_html__( 'Edit Service', 'optech' ),
            'view_item'          => esc_html__( 'View Service', 'optech' ),
            'all_items'          => esc_html__( 'All Service', 'optech' ),
            'search_items'       => esc_html__( 'Search Service', 'optech' ),
            'parent_item_colon'  => esc_html__( 'Parent Service:', 'optech' ),
            'not_found'          => esc_html__( 'No Service found.', 'optech' ),
            'not_found_in_trash' => esc_html__( 'No Service found in Trash.', 'optech' ),
        );
    
        $args = array(
            'labels'             => $labels,
            'description'        => esc_html__( 'Description.', 'optech' ),
            'public'             => true,
            'publicly_queryable' => true,
            'show_ui'            => true,
            'show_in_menu'       => true,
            'query_var'          => true,
            'has_archive'        => false,
            'hierarchical'       => true,
            'menu_position'      => null,
            'show_in_rest'       => true,
            'menu_icon'          => 'dashicons-edit-page',
            'supports'           => array( 'title','thumbnail','editor','excerpt','elementor' ),
            'rewrite'            => array( 'slug' => 'services' ),
        );
        register_post_type( 'optech_service', $args );
    }


    /*----------  Team ----------*/   
    public function optech_team() 
    {
        $labels = array(
            'name'               => esc_html__( 'Teams', 'Team general name', 'optech' ),
            'singular_name'      => esc_html__( 'Team', 'Team singular name', 'optech' ),
            'menu_name'          => esc_html__( 'Teams', 'admin menu', 'optech' ),
            'name_admin_bar'     => esc_html__( 'Team', 'add new on admin bar', 'optech' ),
            'add_new'            => esc_html__( 'Add New', 'Team', 'optech' ),
            'add_new_item'       => esc_html__( 'Add New Team', 'optech' ),
            'new_item'           => esc_html__( 'New Team', 'optech' ),
            'edit_item'          => esc_html__( 'Edit Team', 'optech' ),
            'view_item'          => esc_html__( 'View Team', 'optech' ),
            'all_items'          => esc_html__( 'All Team', 'optech' ),
            'search_items'       => esc_html__( 'Search Team', 'optech' ),
            'parent_item_colon'  => esc_html__( 'Parent Team:', 'optech' ),
            'not_found'          => esc_html__( 'No Team found.', 'optech' ),
            'not_found_in_trash' => esc_html__( 'No Team found in Trash.', 'optech' ),
        );
    
        $args = array(
            'labels'             => $labels,
            'description'        => esc_html__( 'Description.', 'optech' ),
            'public'             => true,
            'publicly_queryable' => true,
            'show_ui'            => true,
            'show_in_menu'       => true,
            'query_var'          => true,
            'has_archive'        => true,
            'hierarchical'       => false,
            'menu_position'      => null,
            'show_in_rest'       => true,
            'menu_icon'          => 'dashicons-id',
            'supports'           => array( 'title','thumbnail','editor','elementor' ),
            'rewrite'            => array( 'slug' => 'teams' ),
        );
        register_post_type( 'optech_team', $args );
    }


    /*----------  Project ----------*/   
    public function optech_project() 
    {
        $labels = array(
            'name'               => esc_html__( 'Projects', 'Project general name', 'optech' ),
            'singular_name'      => esc_html__( 'Project', 'Project singular name', 'optech' ),
            'menu_name'          => esc_html__( 'Projects', 'admin menu', 'optech' ),
            'name_admin_bar'     => esc_html__( 'Project', 'add new on admin bar', 'optech' ),
            'add_new'            => esc_html__( 'Add New', 'Project', 'optech' ),
            'add_new_item'       => esc_html__( 'Add New Project', 'optech' ),
            'new_item'           => esc_html__( 'New Project', 'optech' ),
            'edit_item'          => esc_html__( 'Edit Project', 'optech' ),
            'view_item'          => esc_html__( 'View Project', 'optech' ),
            'all_items'          => esc_html__( 'All Projects', 'optech' ),
            'search_items'       => esc_html__( 'Search Projects', 'optech' ),
            'parent_item_colon'  => esc_html__( 'Parent Projects:', 'optech' ),
            'not_found'          => esc_html__( 'No Projects found.', 'optech' ),
            'not_found_in_trash' => esc_html__( 'No Projects found in Trash.', 'optech' ),
        );
    
        $args = array(
            'labels'             => $labels,
            'description'        => esc_html__( 'Description.', 'optech' ),
            'public'             => true,
            'publicly_queryable' => true,
            'show_ui'            => true,
            'show_in_menu'       => true,
            'query_var'          => true,
            'has_archive'        => true,
            'hierarchical'       => false,
            'menu_position'      => null,
            'show_in_rest'       => true,
            'menu_icon'          => 'dashicons-portfolio',
            'supports'           => array( 'title','thumbnail','editor','excerpt','elementor' ),
            'rewrite'            => array( 'slug' => 'projects' ),
        );
        register_post_type( 'optech_project', $args );
    }

    // Project Category
    public function optech_project_category() {

        $labels = array(
            'name'                       => esc_html__( 'Categories', 'taxonomy general name', 'optech' ),
            'singular_name'              => esc_html__( 'Category', 'taxonomy singular name', 'optech' ),
            'search_items'               => esc_html__( 'Search Categorys', 'optech' ),
            'popular_items'              => esc_html__( 'Popular Categorys', 'optech' ),
            'all_items'                  => esc_html__( 'All Categorys', 'optech' ),
            'parent_item'                => null,
            'parent_item_colon'          => null,
            'edit_item'                  => esc_html__( 'Edit Category', 'optech' ),
            'update_item'                => esc_html__( 'Update Category', 'optech' ),
            'add_new_item'               => esc_html__( 'Add New Category', 'optech' ),
            'new_item_name'              => esc_html__( 'New Category Name', 'optech' ),
            'separate_items_with_commas' => esc_html__( 'Separate Categorys with commas', 'optech' ),
            'add_or_remove_items'        => esc_html__( 'Add or remove Categorys', 'optech' ),
            'choose_from_most_used'      => esc_html__( 'Choose from the most used Categorys', 'optech' ),
            'not_found'                  => esc_html__( 'No Categorys found.', 'optech' ),
            'menu_name'                  => esc_html__( 'Categories', 'optech' ),
        );
    
        $args = array(
            'hierarchical'          => true,
            'labels'                => $labels,
            'show_ui'               => true,
            'show_admin_column'     => true,
            'update_count_callback' => '_update_post_term_count',
            'query_var'             => true,
            'show_in_rest'          => true,
            'rewrite'               => array( 'slug' => 'project-cat' ),
        );
        register_taxonomy( 'project_category', 'optech_project', $args );
    }
    
}
$Optech_StydyInstance = new OptechCustomPosts;

