(function ($) {
    'use strict';

    /* ---------------------------------------------

    -- Service Slider

    --------------------------------------------- */
    /* is_exist() */
    jQuery.fn.is_exist = function () {
        return this.length;
    };

    $(window).load(function () {});

    /********* * Service Slider * *********/
    var Service_slider_Js = function ($scope) {
        var wrapper = $scope.find('.optech-4column-slider');

        if (wrapper.length === 0) return;

        var settings = wrapper.data('settings');

        wrapper.slick({
            infinite: true,
            slidesToShow: settings['per_coulmn'],
            slidesToScroll: 1,
            arrows: false,
            dots: settings['dots'],
            autoplay: settings['autoplay'],
            autoplaySpeed: settings['autoplaytimeout'],
            draggable: settings['drag'],
            centerMode: settings['centermode'],
            centerPadding: '300px',
            responsive: [
                {
                    breakpoint: 1600,
                    settings: {
                        slidesToShow: 3,
                        centerPadding: '250px',
                    },
                },
                {
                    breakpoint: 1399,
                    settings: {
                        slidesToShow: 3,
                        centerPadding: '150px',
                    },
                },
                {
                    breakpoint: 1199,
                    settings: {
                        slidesToShow: 3,
                        centerPadding: '100px',
                    },
                },
                {
                    breakpoint: 1025,
                    settings: {
                        slidesToShow: settings['per_coulmn_tablet'],
                        centerPadding: '100px',
                    },
                },
                {
                    breakpoint: 768,
                    settings: {
                        slidesToShow: settings['per_coulmn_mobile'],
                        centerPadding: '0px',
                    },
                },
            ],
        });
    };

    var Service_slider_Js_Two = function ($scope) {
        var wrapper = $scope.find('.optech-4column-slider2');

        if (wrapper.length === 0) return;

        var settings = wrapper.data('settings');

        wrapper.slick({
            infinite: true,
            slidesToShow: settings['per_coulmn'],
            slidesToScroll: 1,
            arrows: false,
            dots: settings['dots'],
            autoplay: settings['autoplay'],
            autoplaySpeed: settings['autoplaytimeout'],
            draggable: settings['drag'],
            responsive: [
                {
                    breakpoint: 1600,
                    settings: {
                        slidesToShow: 3,
                    },
                },
                {
                    breakpoint: 1399,
                    settings: {
                        slidesToShow: 3,
                    },
                },
                {
                    breakpoint: 1199,
                    settings: {
                        slidesToShow: 3,
                    },
                },
                {
                    breakpoint: 1025,
                    settings: {
                        slidesToShow: settings['per_coulmn_tablet'],
                    },
                },
                {
                    breakpoint: 768,
                    settings: {
                        slidesToShow: settings['per_coulmn_mobile'],
                    },
                },
            ],
        });
    };

    /*---------- Optech 1 Column Slider ----------*/

    var Testimonial_slider_One_Js = function ($scope) {
        var wrapper = $scope.find('.testi-slider-active');

        if (wrapper.length === 0) return;

        var settings = wrapper.data('settings');

        wrapper.slick({
            infinite: true,
            slidesToShow: settings['per_coulmn'],
            slidesToScroll: 1,
            arrows: settings['arrows'],
            dots: settings['dots'],
            autoplay: settings['autoplay'],
            autoplaySpeed: settings['autoplaytimeout'],
            draggable: settings['drag'],
            speed: 800,
            prevArrow: '<button class="slide-arrow optech-t-next"><i class="ri-arrow-left-s-line"></i></button>',
            nextArrow: '<button class="slide-arrow optech-t-prev"><i class="ri-arrow-right-s-line"></i></button>',
            responsive: [
                {
                    breakpoint: 1025,
                    settings: {
                        slidesToShow: settings['per_coulmn_tablet'],
                    },
                },
                {
                    breakpoint: 768,
                    settings: {
                        slidesToShow: settings['per_coulmn_mobile'],
                    },
                },
            ],
        });
    };

    /*---------- Optech Progress Bar ----------*/
    var Progress_Bar_Js = function ($scope) {
        $scope.find('.progress-bar').each(function () {
            var $this = jQuery(this);

            $this.find('.progress-content').animate(
                {
                    width: $this.attr('data-percentage'),
                },
                2000
            );

            $this.find('.progress-number-mark').animate(
                {
                    left: $this.attr('data-percentage'),
                },
                {
                    duration: 2000,
                    step: function (now, fx) {
                        var data = Math.round(now);
                        jQuery(this)
                            .find('.percent')
                            .html(data + '%');
                    },
                }
            );
        });
    };

    /*---------- Optech Search Js ----------*/
    var Search_Js = function ($scope) {
        // Open search box when clicking on the search icon
        $scope.find('.optech-header-search').on('click', function () {
            $scope.find('.optech-header-search-section, .search-overlay').addClass('open');
        });

        // Close search box when clicking on the close icon or overlay
        $scope.find('.optech-header-search-close, .search-overlay').on('click', function () {
            $scope.find('.optech-header-search-section, .search-overlay').removeClass('open');
        });
    };

    /********* * Team Slider * *********/
    var Team_slider_Js = function ($scope) {
        var wrapper = $scope.find('.team-slide');

        if (wrapper.length === 0) return;

        var settings = wrapper.data('settings');

        wrapper.slick({
            infinite: true,
            slidesToShow: settings['per_coulmn'],
            slidesToScroll: 1,
            arrows: false,
            dots: settings['dots'],
            autoplay: settings['autoplay'],
            autoplaySpeed: settings['autoplaytimeout'],
            draggable: settings['drag'],
            centerMode: settings['centermode'],
            centerPadding: '300px',
            responsive: [
                {
                    breakpoint: 1600,
                    settings: {
                        slidesToShow: 3,
                        centerPadding: '250px',
                    },
                },
                {
                    breakpoint: 1399,
                    settings: {
                        slidesToShow: 3,
                        centerPadding: '150px',
                    },
                },
                {
                    breakpoint: 1199,
                    settings: {
                        slidesToShow: 3,
                        centerPadding: '100px',
                    },
                },
                {
                    breakpoint: 1025,
                    settings: {
                        slidesToShow: settings['per_coulmn_tablet'],
                        centerPadding: '100px',
                    },
                },
                {
                    breakpoint: 768,
                    settings: {
                        slidesToShow: settings['per_coulmn_mobile'],
                        centerPadding: '0px',
                    },
                },
            ],
        });
    };

    /********* * Project Slider * *********/
    var Project_slider_Js = function ($scope) {
        var wrapper = $scope.find('.project-slide');

        if (wrapper.length === 0) return;

        var settings = wrapper.data('settings');

        wrapper.slick({
            infinite: true,
            slidesToShow: settings['per_coulmn'],
            slidesToScroll: 1,
            arrows: false,
            dots: settings['dots'],
            autoplay: settings['autoplay'],
            autoplaySpeed: settings['autoplaytimeout'],
            draggable: settings['drag'],
            centerMode: settings['centermode'],
            centerPadding: '100px',
            responsive: [
                {
                    breakpoint: 1399,
                    settings: {
                        slidesToShow: 2,
                    },
                },
                {
                    breakpoint: 1025,
                    settings: {
                        slidesToShow: settings['per_coulmn_tablet'],
                        centerPadding: '70px',
                    },
                },
                {
                    breakpoint: 768,
                    settings: {
                        slidesToShow: settings['per_coulmn_mobile'],
                        centerPadding: '0px',
                    },
                },
            ],
        });
    };

    /********* * offCanvas Menu * *********/
    var Off_canvs_Menu = function ($scope, $) {
        $('.optech-header-barger').on('click', function (e) {
            $('.optech-sidemenu-column, .offcanvas-overlay').addClass('active');
            event.preventDefault(e);
        });
        $('.optech-sidemenu-close, .offcanvas-overlay').on('click', function () {
            $('.optech-sidemenu-column, .offcanvas-overlay').removeClass('active');
        });
    };

    /********* * Text Slider * *********/
    var text_slider_Js = function ($scope) {
        var wrapper = $scope.find('.optech-brand-slider');

        if (wrapper.length === 0) return;

        var settings = wrapper.data('settings');

        wrapper.slick({
            rtl: settings['slider_rtl'],
            infinite: true,
            slidesToShow: settings['per_coulmn'],
            slidesToScroll: settings['slide_scroll'],
            arrows: false,
            dots: false,
            autoplay: true,
            autoplaySpeed: 0,
            speed: 10000,
            cssEase: 'linear',
            pauseOnHover: true,
            adaptiveHeight: true,
            responsive: [
                {
                    breakpoint: 1600,
                    settings: {
                        slidesToShow: settings['per_coulmn'],
                        slidesToScroll: 1,
                    },
                },
                {
                    breakpoint: 1200,
                    settings: {
                        slidesToShow: 3,
                        slidesToScroll: 1,
                    },
                },
                {
                    breakpoint: 1025,
                    settings: {
                        slidesToShow: settings['per_coulmn_tablet'],
                        slidesToScroll: 1,
                    },
                },
                {
                    breakpoint: 767,
                    settings: {
                        slidesToShow: settings['per_coulmn_mobile'],
                        slidesToScroll: 1,
                    },
                },
            ],
        });
    };

    /*--------------------------------------------------------------
    optech HERO SLIDER INIT
    --------------------------------------------------------------*/
    /*----------- Global Slider ----------*/
    $('.global-carousel').each(function () {
        var carouselSlide = $(this);
        function d(data) {
            return carouselSlide.data(data);
        }
    });
    /*----------- Custom Animaiton For Slider ----------*/
    $('[data-ani-duration]').each(function () {
        var durationTime = $(this).data('ani-duration');
        $(this).css('animation-duration', durationTime);
    });
    $('[data-ani-delay]').each(function () {
        var delayTime = $(this).data('ani-delay');
        $(this).css('animation-delay', delayTime);
    });
    $('[data-ani]').each(function () {
        var animaionName = $(this).data('ani');
        $(this).addClass(animaionName);
        $('.slick-slide [data-ani]').addClass('slider-animated');
    });
    $('.global-carousel').on('afterChange', function (event, slick, currentSlide, nextSlide) {
        $(slick.$slides).find('[data-ani]').removeClass('slider-animated');
        $(slick.$slides[currentSlide]).find('[data-ani]').addClass('slider-animated');
    });

    var hero_slider = function ($scope) {
        var wrapper = $scope.find('.optech-hero-slider');

        if (wrapper.length === 0) return;

        var settings = wrapper.data('settings');
        wrapper.slick({
                infinite: true,
                slidesToShow: 1,
                slidesToScroll: 1,
                arrows: settings['arrows'],
                draggable: settings['drag'],
                autoplay: settings['autoplay'],
                autoplaySpeed: settings['autoplaytimeout'],
                speed: 800,
                lazyLoad: 'progressive',
                prevArrow: '<button class="slide-arrow optech-hero-next"><i class="ri-arrow-left-s-line"></i></button>',
                nextArrow: '<button class="slide-arrow optech-hero-prev"><i class="ri-arrow-right-s-line"></i></button>',
            }).slickAnimation();
    };

    /*--------------------------------------------------------------
    COUNTER JS INIT
    --------------------------------------------------------------*/
    var Counter_Js = function ($scope) {
        var $counterWrap = $scope.find('.optech-counter-number');

        if (!$counterWrap.length) {
            return; // Exit if no counter wrap found
        }

        var a = 0;
        $(window).on('scroll', function () {
            $counterWrap.each(function () {
                var $thisWrap = $(this);
                var oTop = $thisWrap.offset().top - window.innerHeight;

                if (a == 0 && $(window).scrollTop() > oTop) {
                    $scope.find('.optech-counter').each(function () {
                        var $this = $(this);
                        var countTo = $this.attr('data-percentage');

                        $({ countNum: 0 }).animate(
                            {
                                countNum: countTo,
                            },
                            {
                                duration: 4000,
                                easing: 'swing',
                                step: function () {
                                    $this.text(Math.floor(this.countNum));
                                },
                                complete: function () {
                                    $this.text(this.countNum);
                                },
                            }
                        );
                    });
                    a = 1;
                }
            });
        });
    };

    var Faq_js = function ($scope) {
        var Accordion = function (el, multiple) {
            this.el = el || {};
            this.multiple = multiple || false;

            var links = this.el.find('.init-header');
            links.on('click', { el: this.el, multiple: this.multiple }, this.dropdown);
        };

        Accordion.prototype.dropdown = function (e) {
            var $el = e.data.el;
            var $this = $(this);
            var $next = $this.next();

            $next.slideToggle();
            $this.parent().toggleClass('open');

            if (!e.data.multiple) {
                $el.find('.init-body').not($next).slideUp().parent().removeClass('open');
            }
        };

        // Initialize the accordion
        var accordion = new Accordion($('.init-wrap'), false);
    };

    $(window).on('elementor/frontend/init', function () {
        // elementorFrontend.hooks.addAction("frontend/element_ready/global", OptechGlobal);
        elementorFrontend.hooks.addAction('frontend/element_ready/optechheroslider.default', hero_slider);
        elementorFrontend.hooks.addAction('frontend/element_ready/optech_services.default', Service_slider_Js);
        elementorFrontend.hooks.addAction('frontend/element_ready/optech_services_two.default', Service_slider_Js_Two);
        elementorFrontend.hooks.addAction('frontend/element_ready/optechtestimonialslider.default', Testimonial_slider_One_Js);
        elementorFrontend.hooks.addAction('frontend/element_ready/optechfaqs.default', Faq_js);
        elementorFrontend.hooks.addAction('frontend/element_ready/optechprogressbar.default', Progress_Bar_Js);
        elementorFrontend.hooks.addAction('frontend/element_ready/optechsearch.default', Search_Js);
        elementorFrontend.hooks.addAction('frontend/element_ready/optech_team_member.default', Team_slider_Js);
        elementorFrontend.hooks.addAction('frontend/element_ready/optech_projects.default', Project_slider_Js);
        elementorFrontend.hooks.addAction('frontend/element_ready/optechoffcanvas.default', Off_canvs_Menu);
        elementorFrontend.hooks.addAction('frontend/element_ready/optech_text_slider_widget.default', text_slider_Js);
        elementorFrontend.hooks.addAction('frontend/element_ready/optech_counter.default', Counter_Js);
    });
})(jQuery);
