<?php

if (!defined('ABSPATH')) {
    exit;
}

class Optech_Team_Member extends \Elementor\Widget_Base {

	public function get_name() {
		return 'optech_team_member';
	}

	public function get_title() {
		return esc_html__( 'Team', 'optech' );
	}

	public function get_icon() {
		return 'eicon-code';
	}

	public function get_categories() {
		return [ 'optech-addons' ];
	}

	public function get_keywords() {
		return [ 'team', 'normal', ' slider' ];
	}

    protected function register_controls() {

        $this->start_controls_section(
            'team_settings',
            [
                'label' => __('Team Settings', 'optech'),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        
        $this->add_control(
            'show_slider_settings',
            [
                'label' => __('Slider Active', 'optech'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'optech'),
                'label_off' => __('No', 'optech'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_responsive_control('per_line', [
            'label'              => __('Columns per row', 'optech'),
            'type'               => \Elementor\Controls_Manager::SELECT,
            'default'            => '3',
            'tablet_default'     => '6',
            'mobile_default'     => '12',
            'options'            => [
                '12' => '1',
                '6'  => '2',
                '4'  => '3',
                '3'  => '4',
            ],
            'frontend_available' => true,
            'condition'   => [ 'show_slider_settings' => '', ]
        ]);
        $this->add_responsive_control(
            'gap_bottom',
            [
                'label'          => __('Gap Bottom', 'optech'),
                'type'           => \Elementor\Controls_Manager::SLIDER,
                'size_units'     => ['px', '%'],
                'range'          => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .optech-team-wrap' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        // Slider Setting
        $this->start_controls_section('slider_settings',
        [
            'label' => __('Slider Settings', 'optech'),
            'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            'condition' => [ 'show_slider_settings' => 'yes',  ]
            ]
        );
        $this->add_responsive_control(
            'per_coulmn',
            [
                'label' => __( 'Slider Items', 'optech' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default'            => 3,
                'tablet_default'     => 2,
                'mobile_default'     => 1,
                'options'            => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                ],
                'frontend_available' => true,
            ]
        );
        $this->add_responsive_control(
			'gap_right_left',
			[
				'label'          => __('Row Gap(Right-Left)', 'optech'),
				'type'           => \Elementor\Controls_Manager::SLIDER,
				'size_units'     => ['px', '%'],
				'range'          => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors'      => [
					'{{WRAPPER}} .optech-4column-slider .slick-slide' => 'margin-right: {{SIZE}}{{UNIT}}; margin-left: {{SIZE}}{{UNIT}};',
				],
			]
		);	

        $this->add_control(
            'center_mode',
            [
                'label' => __( 'Center Mode?', 'optech' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'optech' ),
                'label_off' => __( 'Hide', 'optech' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'dots',
            [
                'label' => __( 'Dots?', 'optech' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'optech' ),
                'label_off' => __( 'Hide', 'optech' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'drag',
            [
                'label' => __( 'Drag?', 'optech' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'optech' ),
                'label_off' => __( 'Hide', 'optech' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'autoplay',
            [
                'label' => __( 'Auto Play?', 'optech' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'optech' ),
                'label_off' => __( 'Hide', 'optech' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'autoplaytimeout',
            [
                'label' => __( 'Autoplay Timeout', 'optech' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'label_block' => true,
                'default' => '5000',
                'options' => [
                    '1000'  => __( '1 Second', 'optech' ),
                    '2000'  => __( '2 Second', 'optech' ),
                    '3000'  => __( '3 Second', 'optech' ),
                    '4000'  => __( '4 Second', 'optech' ),
                    '5000'  => __( '5 Second', 'optech' ),
                    '6000'  => __( '6 Second', 'optech' ),
                    '7000'  => __( '7 Second', 'optech' ),
                    '8000'  => __( '8 Second', 'optech' ),
                    '9000'  => __( '9 Second', 'optech' ),
                    '10000' => __( '10 Second', 'optech' ),
                    '11000' => __( '11 Second', 'optech' ),
                    '12000' => __( '12 Second', 'optech' ),
                    '13000' => __( '13 Second', 'optech' ),
                    '14000' => __( '14 Second', 'optech' ),
                    '15000' => __( '15 Second', 'optech' ),
                ],
                'condition' => [
                    'autoplay' => 'yes',
                ],
            ]
        );
        $this->end_controls_section();
        // End Slider settings

        // Start team Section
        $this->start_controls_section(
			'team_section',
			[
				'label' => esc_html__( 'Team Section', 'optech' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'select_post',
            [
                'label' => __('Must be Select a Post', 'optech'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'label_block' => true,
                'default' => 'none',
                'options' => $this->get_all_members(),
            ]
        );
        $repeater->add_control(
			'designation_text',
			[
				'label' => esc_html__( 'Designation', 'optech' ),
				'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
				'default' => esc_html__( 'CEO & Founder', 'optech' ),
			]
		);
        $repeater->start_controls_tabs(
            'social_icons_tabs'
        );
        $repeater->start_controls_tab(
            'social_icons_tab',
            [
                'label' => __('Icons', 'optech'),
            ]
        );
        $repeater->add_control(
			'social_icon_one',
			[
				'label'       => __( 'Icon 01', 'optech' ),
				'type'        => \Elementor\Controls_Manager::ICONS,
				'label_block' => true,
			]
		);
        $repeater->add_control(
			'social_icon_two',
			[
				'label'       => __( 'Icon 02', 'optech' ),
				'type'        => \Elementor\Controls_Manager::ICONS,
				'label_block' => true,
			]
		);
        $repeater->add_control(
			'social_icon_three',
			[
				'label'       => __( 'Icon 03', 'optech' ),
				'type'        => \Elementor\Controls_Manager::ICONS,
				'label_block' => true,
			]
		);
        $repeater->add_control(
			'social_icon_four',
			[
				'label'       => __( 'Icon 04', 'optech' ),
				'type'        => \Elementor\Controls_Manager::ICONS,
				'label_block' => true,
			]
		);
        $repeater->end_controls_tab();

        $repeater->start_controls_tab(
            'social_linkss_tab',
            [
                'label' => __('URLs', 'optech'),
            ]
        );
        $repeater->add_control(
			'icon_url_one',
			[
				'label' => __('URL 01', 'optech'),
				'type' =>  \Elementor\Controls_Manager::URL,
			]
		);
        $repeater->add_control(
			'icon_url_two',
			[
				'label' => __('URL 02', 'optech'),
				'type' =>  \Elementor\Controls_Manager::URL,
			]
		);
        $repeater->add_control(
			'icon_url_three',
			[
				'label' => __('URL 03', 'optech'),
				'type' =>  \Elementor\Controls_Manager::URL,
			]
		);
        $repeater->add_control(
			'icon_url_four',
			[
				'label' => __('URL 04', 'optech'),
				'type' =>  \Elementor\Controls_Manager::URL,
			]
		);
        $repeater->end_controls_tab();
        $repeater->end_controls_tabs();

        $this->add_control(
            'team_lists',
            [
                'label' => __('Team Lists', 'optech'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );
		$this->end_controls_section();

        // start Title style
        $this->start_controls_section(
            'team_title_style',
            [
                    'label' => __('Title', 'optech'),
                    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'title_style_tabs'
        );
        $this->start_controls_tab(
                'title_style_normal_tab',
                [
                        'label' => __('Normal', 'optech'),
                ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .optech-team-data h5',
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Color', 'optech' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-team-data h5' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_responsive_control(
			'title_margin',
			[
				'label' => esc_html__( 'Margin', 'optech' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .optech-team-data h5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);
		$this->add_responsive_control(
			'title_padding',
			[
				'label' => esc_html__( 'Padding', 'optech' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .optech-team-data h5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);
        $this->end_controls_tab();

        $this->start_controls_tab(
            'title_style_hover_tab',
            [
                    'label' => __('Hover', 'optech'),
            ]
        );
        $this->add_control(
			'title_hover_color',
			[
				'label' => esc_html__( 'Color', 'optech' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-team-data h5:hover' => 'color: {{VALUE}}',
				],
			]
		);
        $this->end_controls_tab();
        $this->end_controls_tabs();
		$this->end_controls_section();

        // start Text style
        $this->start_controls_section(
            'team_text_style',
            [
                    'label' => __('Text', 'optech'),
                    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography',
				'selector' => '{{WRAPPER}} .optech-team-data p',
			]
		);
		$this->add_control(
			'text_color',
			[
				'label' => esc_html__( 'Color', 'optech' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-team-data p' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_responsive_control(
			'text_margin',
			[
				'label' => esc_html__( 'Margin', 'optech' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .optech-team-data p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);
		$this->end_controls_section();

        // start content box style
        $this->start_controls_section(
            'team_content_box_style',
            [
                    'label' => __('Content Box', 'optech'),
                    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
			'content_box_bg_color',
			[
					'label'     => __('Background Color', 'optech'),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
							'{{WRAPPER}} .optech-team-data' => 'background-color: {{VALUE}}',
					],
			]
		);
        $this->add_responsive_control(
			'content_box_padding',
			[
				'label' => esc_html__( 'Padding', 'optech' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .optech-team-data' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);
		$this->end_controls_section();

        // start box style
        $this->start_controls_section(
            'team_box_style',
            [
                    'label' => __('Box', 'optech'),
                    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs(
            'box_style_tabs'
        );
        $this->start_controls_tab(
                'box_style_normal_tab',
                [
                        'label' => __('Normal', 'optech'),
                ]
        );
        $this->add_responsive_control(
			'box_bg_color',
			[
					'label'     => __('Background Color', 'optech'),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
							'{{WRAPPER}} .optech-team-wrap' => 'background-color: {{VALUE}}',
					],
			]
		);
        $this->add_responsive_control(
			'box_padding',
			[
				'label' => esc_html__( 'Padding', 'optech' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .optech-team-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);
        $this->add_responsive_control(
			'box_margin',
			[
				'label' => esc_html__( 'Margin', 'optech' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .optech-team-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_hover_shadow',
				'label' => esc_html__( 'Box Shadow', 'optech' ),
				'selector' => '{{WRAPPER}} .optech-team-wrap',
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' 		=> 'team_box_border',
				'label' 	=> __( 'Border', 'optech' ),
                'selector' 	=> '{{WRAPPER}} .optech-team-wrap',
			]
		);
        $this->add_responsive_control(
			'box_radius',
			[
				'label' => esc_html__( 'Border Radius', 'optech' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .optech-team-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
		);
        $this->end_controls_tab();

        // hover tab start
        $this->start_controls_tab(
            'box_style_hover_tab',
            [
                    'label' => __('Hover', 'optech'),
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' 		=> 'team_box_border_hover',
				'label' 	=> __( 'Border', 'optech' ),
                'selector' 	=> '{{WRAPPER}} .optech-team-wrap:hover',
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'team_box_shadow_hover',
				'label' => esc_html__( 'Box Shadow', 'optech' ),
				'selector' => '{{WRAPPER}} .optech-team-wrap:hover',
			]
		);
        $this->end_controls_tab();
        $this->end_controls_tabs();
		$this->end_controls_section();

        // icon Style
        $this->start_controls_section(
			'icon_style_section',
			[
				'label' 	=> __( 'Icon', 'optech' ),
				'tab' 		=> \Elementor\Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
			'icon_color',
			[
				'label' 		=> __( 'Icon Color', 'optech' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-social-icon-box.style-three ul li a' => 'color: {{VALUE}}',
                ],
			]
        );
        $this->add_control(
			'icon_color_hover',
			[
				'label' 		=> __( 'Icon Color Hover', 'optech' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-social-icon-box.style-three ul li a:hover' => 'color: {{VALUE}}',
                ],
			]
        );
        $this->add_control(
			'icon_bg_color',
			[
				'label' 		=> __( 'Background Color', 'optech' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-social-icon-box.style-three ul li a' => 'background-color: {{VALUE}}',
                ],
			]
        );
        $this->add_control(
			'icon_bg_color_hover',
			[
				'label' 		=> __( 'Background Hover Color', 'optech' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-social-icon-box.style-three ul li a:hover' => 'background-color: {{VALUE}}',
                ],
			]
        );
        $this->add_control(
			'icon_size',
			[
				'label' => esc_html__( 'Size', 'optech' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 30,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .optech-social-icon-box ul li a i' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .optech-social-icon-box ul li a svg' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_control(
			'icon_box_size',
			[
				'label' => esc_html__( 'Box Size', 'optech' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 30,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .optech-social-icon-box ul li a' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
			'iconbox_radius',
			[
				'label' => esc_html__( 'Border Radius', 'optech' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .optech-social-icon-box ul li a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
		);
		$this->end_controls_section();


	}

    // Get All teams
    public function get_all_members() {

        $wp_query = get_posts([
            'post_type' => 'optech_team',
            'orderby' => 'date',
            'posts_per_page' => -1,
        ]);

        $options = ['none' => 'None'];
        foreach ($wp_query as $teams) {
            $options[$teams->ID] = $teams->post_title;
        }

        return $options;
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        //this code course slider option
		$slider_extraSetting = array(
	        'autoplay' => (!empty($settings['autoplay']) && 'yes' === $settings['autoplay']) ? true : false,
            'drag' => (!empty($settings['drag']) && 'yes' === $settings['drag']) ? true : false,
            'dots' => (!empty($settings['dots']) && 'yes' === $settings['dots']) ? true : false,
            'centermode' => (!empty($settings['center_mode']) && 'yes' === $settings['center_mode']) ? true : false,
        	'autoplaytimeout' => !empty($settings['autoplaytimeout']) ? $settings['autoplaytimeout'] : '5000',

        	//this a responsive layout
            'per_coulmn' =>        (!empty($settings['per_coulmn'])) ? $settings['per_coulmn'] : 3,
            'per_coulmn_tablet' => (!empty($settings['per_coulmn_tablet'])) ? $settings['per_coulmn_tablet'] : 2,
            'per_coulmn_mobile' => (!empty($settings['per_coulmn_mobile'])) ? $settings['per_coulmn_mobile'] : 1
        );
        $jasondecode = wp_json_encode($slider_extraSetting);


        if ( ( 'yes' == $settings['show_slider_settings'] ) ) {
            $this->add_render_attribute('team_version', 'class', ['row team-slide optech-4column-slider']);
            $this->add_render_attribute('team_version', 'data-settings', $jasondecode);
            // $this->add_render_attribute('team_gride_classes', 'class', ['item']);

            $anim = " ";
        } else {
            $this->add_render_attribute('team_version', 'class', ['row']);
            //gride class
            $grid_classes = [];
            $grid_classes[] = 'col-xl-' . $settings['per_line'];
            $grid_classes[] = 'col-md-' . $settings['per_line_tablet'];
            $grid_classes[] = 'col-sm-' . $settings['per_line_mobile'];
            $grid_classes = implode(' ', $grid_classes);
            $this->add_render_attribute('team_gride_classes', 'class', [$grid_classes]);
            
            $anim = "onview: -100; targets: > *; translateY: [48, 0]; opacity: [0, 1]; easing: spring(1, 80, 10, 0); duration: 450; delay: anime.stagger(100, {start: 200});";
        }

        $team_lists = $settings['team_lists'];?>  

        <div  <?php echo $this->get_render_attribute_string('team_version'); ?> data-anime="<?php echo $anim; ?>" data-uc-grid>
            <?php  foreach( $team_lists as $item ):
                $args = new \WP_Query(array(
                    'post_type' => 'optech_team',
                    'post_status' => 'publish',
                    'post__in' => [
                        $item['select_post']
                    ]
                ));
                ?>
                <?php while ($args->have_posts()) : $args->the_post(); ?>
                    <div <?php echo $this->get_render_attribute_string('team_gride_classes'); ?>>
                        <div class="optech-team-wrap" >
                            <?php if( has_post_thumbnail() ): ?>
                                <div class="optech-team-thumb">
                                    <?php the_post_thumbnail('full');?>
                                    <div class="optech-social-icon-box style-three position">
                                        <ul>
                                            <?php if ( ! empty( $item['social_icon_one']['value'] ) && ! empty( $item['icon_url_one']['url'] ) ) : ?>
                                                <li>
                                                    <a href="<?php echo esc_url( $item['icon_url_one']['url'] ); ?>">
                                                        <?php \Elementor\Icons_Manager::render_icon( $item['social_icon_one'], [ 'aria-hidden' => 'true' ] ); ?>
                                                    </a>
                                                </li>
                                            <?php endif; ?>

                                            <?php if ( ! empty( $item['social_icon_two']['value'] ) && ! empty( $item['icon_url_two']['url'] ) ) : ?>
                                                <li>
                                                    <a href="<?php echo esc_url( $item['icon_url_two']['url'] ); ?>">
                                                        <?php \Elementor\Icons_Manager::render_icon( $item['social_icon_two'], [ 'aria-hidden' => 'true' ] ); ?>
                                                    </a>
                                                </li>
                                            <?php endif; ?>

                                            <?php if ( ! empty( $item['social_icon_three']['value'] ) && ! empty( $item['icon_url_three']['url'] ) ) : ?>
                                                <li>
                                                    <a href="<?php echo esc_url( $item['icon_url_three']['url'] ); ?>">
                                                        <?php \Elementor\Icons_Manager::render_icon( $item['social_icon_three'], [ 'aria-hidden' => 'true' ] ); ?>
                                                    </a>
                                                </li>
                                            <?php endif; ?>

                                            <?php if ( ! empty( $item['social_icon_four']['value'] ) && ! empty( $item['icon_url_four']['url'] ) ) : ?>
                                                <li>
                                                    <a href="<?php echo esc_url( $item['icon_url_four']['url'] ); ?>">
                                                        <?php \Elementor\Icons_Manager::render_icon( $item['social_icon_four'], [ 'aria-hidden' => 'true' ] ); ?>
                                                    </a>
                                                </li>
                                            <?php endif; ?>
                                        </ul>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <div class="optech-team-data">
                                <a href="<?php the_permalink(); ?>">
                                    <h5><?php the_title(); ?></h5>
                                </a>
                                <p><?php echo esc_html($item['designation_text']); ?></p>
                            </div>
                        </div>
                    </div>
                <?php endwhile; wp_reset_postdata(); ?>
            <?php endforeach; ?>
        </div>
        <?php
    }

}

$widgets_manager->register( new \Optech_Team_Member() );