<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\ICONS;
use \Elementor\Repeater;
/**
 *
 * Social_Profile Widget .
 *
 */
class Optech_Social_Profile extends Widget_Base {

	public function get_name() {
		return 'optechsocial_profile';
	}

	public function get_title() {
		return __( 'Social Profile', 'optech' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'optech' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'social_profile_section',
			[
				'label' 	=> __( 'Social Profiles', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
		
		$repeater = new Repeater();
		
        $repeater->add_control(
			'social_profile_link',
			[
				'label' 		=> __( 'Link', 'optech' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://facebook.com', 'optech' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> 'https://facebook.com',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);
		$repeater->add_control(
			'social_icon',
			[
				'label' => __( 'Icon', 'optech' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'remixicon ri-facebook-fill',
					'library' => 'remixicon',
				]
			]
		);
		$this->add_control(
			'social_profile',
			[
				'label' 		=> __( 'Social Icons', 'optech' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'title_field' => '<i class="{{ social_icon.value }}"></i> {{ social_icon.value }}',
			]
		);
        $this->add_responsive_control(
			'social_profile_align',
			[
				'label' 		=> __( 'Alignment', 'optech' ),
				'type' 			=> Controls_Manager::CHOOSE,
				'options' 		=> [
					'left' 			=> [
						'title' 		=> __( 'Left', 'optech' ),
						'icon' 			=> 'eicon-text-align-left',
					],
					'center' 		=> [
						'title' 		=> __( 'Center', 'optech' ),
						'icon' 			=> 'eicon-text-align-center',
					],
						'right' 	=> [
						'title' 		=> __( 'Right', 'optech' ),
						'icon' 			=> 'eicon-text-align-right',
					],
				],
				'default' 		=> 'left',
				'toggle' 		=> true,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-social-icon-box ul' => 'text-align: {{VALUE}}',
                ],
			]
        );
        $this->end_controls_section();

		// Social_Profile Style
        $this->start_controls_section(
			'social_profile_style_section',
			[
				'label' 	=> __( 'Social_Profile Style', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
			'social_profile_color',
			[
				'label' 		=> __( 'Social_Profile Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-social-icon-box ul li a' => 'color: {{VALUE}}',
                ],
			]
        );
        $this->add_control(
			'social_profile_color_hover',
			[
				'label' 		=> __( 'Social_Profile Color Hover', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-social-icon-box ul li a:hover' => 'color: {{VALUE}} !important',
                ],
			]
        );
        $this->add_control(
			'social_profile_bg_color',
			[
				'label' 		=> __( 'Background Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-social-icon-box ul li a' => 'background: {{VALUE}} !important',
                ],
			]
        );
        $this->add_control(
			'social_profile_bg_color_hover',
			[
				'label' 		=> __( 'Background Hover Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-social-icon-box ul li a:hover' => 'background: {{VALUE}} !important',
                ],
			]
        );
		$this->add_responsive_control(
			'social_profile_icon_gap',
			[
				'label' => __( 'Icon Gap', 'optech' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 15,
						'step' => 1,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .optech-social-icon-box ul li' => 'margin-right: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'social_profile_icon_size',
			[
				'label' => __( 'Icon Size', 'optech' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 30,
						'step' => 1,
					]
				],
				'default' => [
					'unit' => 'px',
					'size' => 20,
				],
				'selectors' => [
					'{{WRAPPER}} .optech-social-icon-box ul li a i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'social_profile_icon_box_size',
			[
				'label' => __( 'Icon Box Size', 'optech' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .optech-social-icon-box ul li a' => 'height: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'border',
				'label' 	=> __( 'Border', 'optech' ),
                'selector' 	=> '{{WRAPPER}} .optech-social-icon-box ul li a',
			]
		);
        $this->add_responsive_control(
			'social_profile_border_radius',
			[
				'label' 		=> __( 'Social_Profile Border Radius', 'optech' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .optech-social-icon-box ul li a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' 		=> 'box_shadow',
				'label' 	=> __( 'Box Shadow', 'optech' ),
				'selector' 	=> '{{WRAPPER}} ..optech-social-icon-box ul li a',
			]
		);

		
        $this->end_controls_section();

    }
	

	protected function render() {

        $settings = $this->get_settings_for_display();
		?>	
		<div class="optech-social-icon-box">
			<ul>
				<?php foreach( $settings['social_profile'] as $single_data ): ?>
					<?php
					// Determine 'nofollow' and 'target' attributes for each item inside the loop
					$nofollow = $single_data['social_profile_link']['nofollow'] ? 'rel="nofollow"' : '';
					$target = $single_data['social_profile_link']['is_external'] ? 'target="_blank"' : ''; 
					$url = $single_data['social_profile_link']['url']; 
        			?>
				<li>
					<a href="<?php echo esc_url( $url ); ?>" <?php echo $target; ?> <?php echo $nofollow; ?>>
						<div class="socail-show">
							<?php \Elementor\Icons_Manager::render_icon( $single_data['social_icon'], [ 'aria-hidden' => 'true' ] ); ?>
						</div>

						<div class="socail-hide">
							<?php \Elementor\Icons_Manager::render_icon( $single_data['social_icon'], [ 'aria-hidden' => 'true' ] ); ?>
						</div>
					</a>
				</li>
				<?php endforeach; ?>
			</ul>
			</div>
		<?php
	}

}
$widgets_manager->register( new \Optech_Social_Profile() );