<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
/**
 *
 * Social_Profile Widget .
 *
 */
class Optech_Social_Profile extends Widget_Base {

	public function get_name() {
		return 'optechsocial_profile';
	}

	public function get_title() {
		return __( 'Social Profile', 'optech' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'optech' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'social_profile_section',
			[
				'label' 	=> __( 'Social Profile', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'social_profile_text',
			[
				'label' 	=> __( 'Social Profile', 'optech' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Social_Profile Text', 'optech' )
			]
        );
        $this->add_control(
			'social_profile_link',
			[
				'label' 		=> __( 'Link', 'optech' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'optech' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);
        $this->add_responsive_control(
			'social_profile_align',
			[
				'label' 		=> __( 'Alignment', 'optech' ),
				'type' 			=> Controls_Manager::CHOOSE,
				'options' 		=> [
					'left' 			=> [
						'title' 		=> __( 'Left', 'optech' ),
						'icon' 			=> 'eicon-text-align-left',
					],
					'center' 		=> [
						'title' 		=> __( 'Center', 'optech' ),
						'icon' 			=> 'eicon-text-align-center',
					],
						'right' 	=> [
						'title' 		=> __( 'Right', 'optech' ),
						'icon' 			=> 'eicon-text-align-right',
					],
				],
				'default' 		=> 'left',
				'toggle' 		=> true,
				'selectors' 	=> [
					'{{WRAPPER}} .btn-wrapper' => 'text-align: {{VALUE}}',
                ],
			]
        );
        $this->end_controls_section();

		// Social_Profile Style
        $this->start_controls_section(
			'social_profile_style_section',
			[
				'label' 	=> __( 'Social_Profile Style', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
			'social_profile_color',
			[
				'label' 		=> __( 'Social_Profile Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-default-btn' => 'color: {{VALUE}} !important',
                ],
			]
        );
        $this->add_control(
			'social_profile_color_hover',
			[
				'label' 		=> __( 'Social_Profile Color Hover', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-default-btn::after, .optech-default-btn:hover' => 'color: {{VALUE}} !important',
                ],
			]
        );
        $this->add_control(
			'social_profile_bg_color',
			[
				'label' 		=> __( 'Background Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-default-btn' => 'background-color: {{VALUE}} !important',
                ],
			]
        );
        $this->add_control(
			'social_profile_bg_color_hover',
			[
				'label' 		=> __( 'Background Hover Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-default-btn::before' => 'background-color: {{VALUE}} !important',
                ],
			]
        );
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'social_profile_typography',
				'label' 	=> __( 'Social_Profile Typography', 'optech' ),
                'selector' 	=> '{{WRAPPER}} .optech-default-btn',
			]
        );
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'border',
				'label' 	=> __( 'Border', 'optech' ),
                'selector' 	=> '{{WRAPPER}} .optech-default-btn',
			]
		);
        $this->add_responsive_control(
			'social_profile_padding',
			[
				'label' 		=> __( 'Social_Profile Padding', 'optech' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [ 
					'{{WRAPPER}} .optech-default-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
        $this->add_responsive_control(
			'social_profile_border_radius',
			[
				'label' 		=> __( 'Social_Profile Border Radius', 'optech' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .optech-default-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' 		=> 'box_shadow',
				'label' 	=> __( 'Box Shadow', 'optech' ),
				'selector' 	=> '{{WRAPPER}} .optech-default-btn',
			]
		);
        $this->end_controls_section();

    }
	

	protected function render() {

        $settings = $this->get_settings_for_display();

		$noflow =  $settings['social_profile_link']['nofollow'] ? 'rel="nofollow"' : '';
		$target = $settings['social_profile_link']['is_external'] ? 'target="_blank"' : ''; 
		$url = $settings['social_profile_link']['url']; 

        
		?>	
			
		<?php
	}

}
$widgets_manager->register( new \Optech_Social_Profile() );