<?php

if (!defined('ABSPATH')) {
    exit;
}

class Optech_Service_Slider_Two extends \Elementor\Widget_Base {

	public function get_name() {
		return 'optech_services_two';
	}

	public function get_title() {
		return esc_html__( 'Services Two', 'optech' );
	}

	public function get_icon() {
		return 'eicon-code';
	}

	public function get_categories() {
		return [ 'optech-addons' ];
	}


	public function get_keywords() {
		return [ 'service', 'normal', ' slider', 'service two' ];
	}

    protected function register_controls() {

        $this->start_controls_section(
            'service_settings',
            [
                'label' => __('Service Settings', 'optech'),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'show_slider_settings',
            [
                'label' => __('Slider Active', 'optech'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'optech'),
                'label_off' => __('No', 'optech'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_responsive_control('per_line', [
            'label'              => __('Columns per row', 'optech'),
            'type'               => \Elementor\Controls_Manager::SELECT,
            'default'            => '3',
            'tablet_default'     => '6',
            'mobile_default'     => '12',
            'options'            => [
                '12' => '1',
                '6'  => '2',
                '4'  => '3',
                '3'  => '4',
            ],
            'frontend_available' => true,
            'condition'   => [ 'show_slider_settings' => '', ]
        ]);
        $this->add_responsive_control(
            'gap_bottom',
            [
                'label'          => __('Gap Bottom', 'optech'),
                'type'           => \Elementor\Controls_Manager::SLIDER,
                'size_units'     => ['px', '%'],
                'range'          => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .optech-service-box' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        // Slider Setting
        $this->start_controls_section('slider_settings',
        [
            'label' => __('Slider Settings', 'optech'),
            'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            'condition' => [ 'show_slider_settings' => 'yes',  ]
            ]
        );
        $this->add_responsive_control(
            'per_coulmn',
            [
                'label' => __( 'Slider Items', 'optech' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default'            => 3,
                'tablet_default'     => 2,
                'mobile_default'     => 1,
                'options'            => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                ],
                'frontend_available' => true,
            ]
        );
        $this->add_responsive_control(
			'gap_right_left',
			[
				'label'          => __('Row Gap(Right-Left)', 'optech'),
				'type'           => \Elementor\Controls_Manager::SLIDER,
				'size_units'     => ['px', '%'],
				'range'          => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors'      => [
					'{{WRAPPER}} .optech-4column-slider2 .slick-slide' => 'margin-right: {{SIZE}}{{UNIT}}; margin-left: {{SIZE}}{{UNIT}};',
				],
			]
		);	
        $this->add_control(
            'dots',
            [
                'label' => __( 'Dots?', 'optech' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'optech' ),
                'label_off' => __( 'Hide', 'optech' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'drag',
            [
                'label' => __( 'Drag?', 'optech' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'optech' ),
                'label_off' => __( 'Hide', 'optech' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'autoplay',
            [
                'label' => __( 'Auto Play?', 'optech' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'optech' ),
                'label_off' => __( 'Hide', 'optech' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'autoplaytimeout',
            [
                'label' => __( 'Autoplay Timeout', 'optech' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'label_block' => true,
                'default' => '5000',
                'options' => [
                    '1000'  => __( '1 Second', 'optech' ),
                    '2000'  => __( '2 Second', 'optech' ),
                    '3000'  => __( '3 Second', 'optech' ),
                    '4000'  => __( '4 Second', 'optech' ),
                    '5000'  => __( '5 Second', 'optech' ),
                    '6000'  => __( '6 Second', 'optech' ),
                    '7000'  => __( '7 Second', 'optech' ),
                    '8000'  => __( '8 Second', 'optech' ),
                    '9000'  => __( '9 Second', 'optech' ),
                    '10000' => __( '10 Second', 'optech' ),
                    '11000' => __( '11 Second', 'optech' ),
                    '12000' => __( '12 Second', 'optech' ),
                    '13000' => __( '13 Second', 'optech' ),
                    '14000' => __( '14 Second', 'optech' ),
                    '15000' => __( '15 Second', 'optech' ),
                ],
                'condition' => [
                    'autoplay' => 'yes',
                ],
            ]
        );
        $this->end_controls_section();
        // End Slider settings

        // Start Service Section
        $this->start_controls_section(
			'service_section',
			[
				'label' => esc_html__( 'Service Section', 'optech' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'select_post',
            [
                'label' => __('Must be Select a Post', 'optech'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'label_block' => true,
                'default' => 'none',
                'options' => $this->get_all_services(),
            ]
        );
        $repeater->add_control(
            'service_icon_select',
            [
                'label' => esc_html__('Icon Select', 'optech'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'optech_service_image' => esc_html__('Image', 'optech'),
                    'optech_service_icon'  => esc_html__('Icon', 'optech'),
                ],
                'default' => 'optech_service_image',
            ]
        );
        $repeater->add_control(
			'optech_service_image',
			[
				'label' => esc_html__( 'Image', 'optech' ),
				'type' =>  \Elementor\Controls_Manager::MEDIA,
                'condition' => [
                    'service_icon_select'    => 'optech_service_image'
                ]
			]
		);
        $repeater->add_control(
			'optech_service_icon',
			[
				'label'       => __( 'Icon', 'optech' ),
				'type'        => \Elementor\Controls_Manager::ICONS,
				'label_block' => true,
				'separator'   =>'after',
				'condition' =>[
					'service_icon_select' => 'optech_service_icon'
				]
			]
		);
        $this->add_control(
            'service_lists',
            [
                'label' => __('Service Lists', 'optech'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
            
        );
		$this->end_controls_section();

        // start icon style
        $this->start_controls_section(
            'service_icon_style',
            [
                    'label' => __('Icon', 'optech'),
                    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
			'service_icon_size',
			[
				'label' => __( 'Size', 'optech' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .optech-iconbox-icon i, .optech-service-data i' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .optech-iconbox-icon svg, .optech-service-data svg' => 'width: {{SIZE}}{{UNIT}};',
				],
                'condition' =>[
					'service_icon_select' => 'optech_service_icon'
				]
			]
		);

        $this->add_control(
			'img_box_bg_color',
			[
				'label' 		=> __( 'Background Color', 'optech' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-service-icon' => 'background-color: {{VALUE}}',
                ],
			]
        );
        $this->add_control(
			'img_box_bg_color_hover',
			[
				'label' 		=> __( 'Background Hover Color', 'optech' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-service-thumb:hover .optech-service-icon' => 'background-color: {{VALUE}}',
                ],
			]
        );
		$this->add_responsive_control(
			'img_box_border_radius',
			[
				'label' 		=> __( 'Border Radius', 'optech' ),
				'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .optech-service-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
		$this->end_controls_section();

        // start Title style
        $this->start_controls_section(
            'service_title_style',
            [
                    'label' => __('Title', 'optech'),
                    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'title_style_tabs'
        );
        $this->start_controls_tab(
                'title_style_normal_tab',
                [
                        'label' => __('Normal', 'optech'),
                ]
        );
        $this->add_responsive_control(
            'service_title_width',
            [
                'label'          => __('Width', 'optech'),
                'type'           => \Elementor\Controls_Manager::SLIDER,
                'size_units'     => ['px'],
                'range'          => [
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .optech-service-data h5' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .optech-service-data h5',
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Color', 'optech' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-service-data h5' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_responsive_control(
			'title_margin',
			[
				'label' => esc_html__( 'Margin', 'optech' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .optech-service-data h5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);
		$this->add_responsive_control(
			'title_padding',
			[
				'label' => esc_html__( 'Padding', 'optech' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .optech-service-data h5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);
        $this->end_controls_tab();

        $this->start_controls_tab(
            'title_style_hover_tab',
            [
                    'label' => __('Hover', 'optech'),
            ]
        );
        $this->add_control(
			'title_hover_color',
			[
				'label' => esc_html__( 'Color', 'optech' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-service-data h5:hover' => 'color: {{VALUE}}',
				],
			]
		);
        $this->end_controls_tab();
        $this->end_controls_tabs();
		$this->end_controls_section();

        

        // start Box style
        $this->start_controls_section(
            'service_box_style',
            [
                    'label' => __('Box', 'optech'),
                    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'service_img_height',
            [
                'label'          => __('Height', 'optech'),
                'type'           => \Elementor\Controls_Manager::SLIDER,
                'size_units'     => ['px','%', 'vh'],
                'range'          => [
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    '%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'vh' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .optech-service-thumb' => 'height: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->add_responsive_control(
			'box_padding',
			[
				'label' => esc_html__( 'Padding', 'optech' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .optech-service-data' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);
		$this->end_controls_section();

        // start Dots style
        $this->start_controls_section(
            'service_dots_style',
            [
                    'label' => __('Dots', 'optech'),
                    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                    'condition'   => [ 'show_slider_settings' => 'yes', ]
            ]
        );
        $this->add_responsive_control(
			'dots_color',
			[
					'label'     => __('Color', 'optech'),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
							'{{WRAPPER}} .optech-4column-slider2 .slick-dots button' => 'background-color: {{VALUE}}',
					],
			]
		);
        $this->add_responsive_control(
			'dots_active_color',
			[
					'label'     => __('Active Color', 'optech'),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
							'{{WRAPPER}} .optech-4column-slider2 .slick-dots li.slick-active button' => 'background-color: {{VALUE}}',
					],
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'dots_border',
				'label' => esc_html__( 'Border', 'optech' ),
				'selector' => '{{WRAPPER}} .optech-4column-slider2 .slick-dots button:before',
			]
		);
		$this->end_controls_section();

	}

    // Get All Services
    public function get_all_services() {

        $wp_query = get_posts([
            'post_type' => 'optech_service',
            'orderby' => 'date',
            'posts_per_page' => -1,
        ]);

        $options = ['none' => 'None'];
        foreach ($wp_query as $services) {
            $options[$services->ID] = $services->post_title;
        }

        return $options;
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        //this code course slider option
		$slider_extraSetting = array(
	        'autoplay' => (!empty($settings['autoplay']) && 'yes' === $settings['autoplay']) ? true : false,
            'drag' => (!empty($settings['drag']) && 'yes' === $settings['drag']) ? true : false,
            'dots' => (!empty($settings['dots']) && 'yes' === $settings['dots']) ? true : false,
        	'autoplaytimeout' => !empty($settings['autoplaytimeout']) ? $settings['autoplaytimeout'] : '5000',

        	//this a responsive layout
            'per_coulmn' =>        (!empty($settings['per_coulmn'])) ? $settings['per_coulmn'] : 3,
            'per_coulmn_tablet' => (!empty($settings['per_coulmn_tablet'])) ? $settings['per_coulmn_tablet'] : 2,
            'per_coulmn_mobile' => (!empty($settings['per_coulmn_mobile'])) ? $settings['per_coulmn_mobile'] : 1
        );
        $jasondecode = wp_json_encode($slider_extraSetting);


        if ( ( 'yes' == $settings['show_slider_settings'] ) ) {
            $this->add_render_attribute('service_version', 'class', ['row optech-4column-slider2']);
            $this->add_render_attribute('service_version', 'data-settings', $jasondecode);
        } else {
            $this->add_render_attribute('service_version', 'class', ['row']);
            //gride class
            $grid_classes = [];
            $grid_classes[] = 'col-xl-' . $settings['per_line'];
            $grid_classes[] = 'col-md-' . $settings['per_line_tablet'];
            $grid_classes[] = 'col-sm-' . $settings['per_line_mobile'];
            $grid_classes = implode(' ', $grid_classes);
            $this->add_render_attribute('service_gride_classes', 'class', [$grid_classes]);
        }
        
        $service_lists = $settings['service_lists'];?>  

        <div  <?php echo $this->get_render_attribute_string('service_version'); ?> >
            <?php  foreach( $service_lists as $item ):
                $args = new \WP_Query(array(
                    'post_type' => 'optech_service',
                    'post_status' => 'publish',
                    'post__in' => [
                        $item['select_post']
                    ]
                ));
            ?>

                <!-- style 3 -->
            <?php while ($args->have_posts()) : $args->the_post(); ?>
                <div <?php echo $this->get_render_attribute_string('service_gride_classes'); ?> > 
                    <div class="optech-service-box">
                        <div class="optech-service-thumb">
                            <?php if( has_post_thumbnail() ): ?>   
                                <?php the_post_thumbnail('full'); ?>
                            <?php endif; ?>
                            <div class="optech-service-data">
                                <div class="optech-service-icon">
                                    <?php if ($item['service_icon_select'] === 'optech_service_image') : ?>
                                        <img src="<?php echo esc_url( $item['optech_service_image']['url'] ); ?>" alt="Image">
                                    <?php elseif($item['service_icon_select'] === 'optech_service_icon'): ?>
                                        <?php \Elementor\Icons_Manager::render_icon( $item['optech_service_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                    <?php endif; ?>
                                </div>
                                
                                <a href="<?php the_permalink() ?>">
                                    <h5><?php the_title(); ?></h5>
                                </a>
                            </div>
                        </div>
                    </div> 
                </div>
            <?php endwhile; wp_reset_postdata(); endforeach;?>
        </div>
        <?php
    }

}

$widgets_manager->register( new \Optech_Service_Slider_Two() );