<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;

class Optech_Service_Cat_Widget extends Widget_Base {

    public function get_name() {
        return 'optech-service-cat';
    }

    public function get_title() {
        return __( 'Service List Menu', 'optech' );
    }

    public function get_icon() {
        return 'eicon-code';
    }

    public function get_categories() {
        return [ 'optech' ];
    }

    protected function register_controls() {
        // Controls section for the title and alignment
        $this->start_controls_section(
            'service_cat',
            [
                'label' => __( 'Service Menu Box', 'optech' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_responsive_control(
			'box_align',
			[
				'label' 		=> __( 'Alignment', 'optech' ),
				'type' 			=> Controls_Manager::CHOOSE,
				'options' 		=> [
					'left' 	=> [
						'title' 		=> __( 'Left', 'optech' ),
						'icon' 			=> 'eicon-text-align-left',
					],
					'center' 	=> [
						'title' 		=> __( 'Center', 'optech' ),
						'icon' 			=> 'eicon-text-align-center',
					],
					'right' 	=> [
						'title' 		=> __( 'Right', 'optech' ),
						'icon' 			=> 'eicon-text-align-right',
					],
				],
				'default' 	=> 'left',
				'toggle' 	=> true,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-service-menu ul li a' => 'text-align: {{VALUE}};',
                ]
			]
		);

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => '_typography',
                'label' => __( 'Typography', 'optech' ),
                'selector' => '{{WRAPPER}} .sec-title',
            ]
        );

		$this->add_control(
			'_color',
			[
				'label' => __( 'Color', 'optech' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-service-menu ul li a' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'hover_color',
			[
				'label' => __( 'Hover Color', 'optech' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-service-menu ul li:hover a' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'bg_color',
			[
				'label' => __( 'Background Color', 'optech' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-service-menu ul li a' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'bg_hover_color',
			[
				'label' => __( 'Background Hover Color', 'optech' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-service-menu ul li:hover a' => 'background: {{VALUE}}',
				],
			]
		);
        
		$this->add_responsive_control(
			'box_margin',
			[
				'label'      => __( 'Margin', 'optech' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px'],
				'selectors'  => [
					'{{WRAPPER}} .optech-service-menu ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_responsive_control(
			'box_padding',
			[
				'label'      => __( 'Padding', 'optech' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px'],
				'selectors'  => [
					'{{WRAPPER}} .optech-service-menu ul li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'box_border',
                'label'    => __( 'Border', 'optech' ),
                'selector' => '{{WRAPPER}} .optech-service-menu ul li a',
            ]
        );

        $this->add_responsive_control(
            'box_border_radius',
            [
                'label'      => __( 'Border Radius', 'optech' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .optech-service-menu ul li a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
            ]
        );
		$this->add_control(
			'icon',
			[
				'label' => esc_html__( 'Icon?', 'optech' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'true', 'optech' ),
				'label_off' => esc_html__( 'false', 'optech' ),
				'return_value' => 'true',
				'default' => 'true',
			]
		);
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        
        // Apply styles dynamically
        ?>
        <div class="optech-service-menu">
            <ul>
                <?php
                $args = array(
                    'post_type'      => 'optech_service',
                    'post_status'    => 'publish',
                    'posts_per_page' => -1,
                    'order'          => 'ASC',
                );

                $query = new WP_Query($args);
                
                if ($query->have_posts()) : 
                    while ($query->have_posts()) : $query->the_post();
                    ?>
                    <li>
                        <a href="<?php echo esc_url(get_permalink()); ?>">
                            <?php the_title(); ?>
                            <?php if( $settings['icon'] == true ): ?>
                                <i class="ri-arrow-right-up-line"></i>
                            <?php endif; ?>
                        </a>
                    </li>
                    <?php
                    endwhile;
                    wp_reset_postdata(); // Reset post data
                endif;
                ?>
            </ul>
        </div>
        <?php
    }
}

$widgets_manager->register( new \Optech_Service_Cat_Widget() );