<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
/**
 *
 * Section Title Widget .
 *
 */
class Optech_Section_Title_Widget extends Widget_Base {

	public function get_name() {
		return 'optechsectiontitle';
	}

	public function get_title() {
		return __( 'Section Title', 'optech' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'optech' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_title_section',
			[
				'label'		 	=> __( 'Section Title', 'optech' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'section_title_style',
			[
				'label' 	=> __( 'Title Style', 'optech' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  		=> __( 'Style One', 'optech' ),
					'2' 		=> __( 'Style Two', 'optech' ),
				],
			]
		);

		$this->add_control(
			'show_image',
			[
				'label'        => __( 'Show Shape', 'optech' ),
				'type'         =>   Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'optech' ),
				'label_off'    => __( 'Hide', 'optech' ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);
		$this->add_control(
			'section_image',
			[
				'label' 	=> __( 'Image', 'optech' ),
				'type' 		=> Controls_Manager::MEDIA,
				'default' => [
					'url' 	=> Utils::get_placeholder_image_src(),
				],
				'condition' => [
                    'show_image'    => 'yes'
                ]
			]
		);
        $this->add_control(
			'section_title',
			[
				'label' 	=> __( 'Section Title', 'optech' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Section Title', 'optech' )
			]
        );
		$this->add_control(
			'section_title_two',
			[
				'label' 	=> __( 'Section Title Two', 'optech' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Section Title', 'optech' ),
				'condition'	=> [ 'section_title_style' => '2' ]
			]
        );
        $this->add_control(
			'section_title_tag',
			[
				'label' 	=> __( 'Title Tag', 'optech' ),
				'type' 		=> Controls_Manager::SELECT,
				'options' 	=> [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
				],
				'default' => 'h2',
			]
        );

        

        $this->add_control(
			'section_subtitle',
			[
				'label' 	=> __( 'Section Subtitle', 'optech' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Section Subtitle', 'optech' )
			]
        );

        $this->add_control(
			'section_subtitle_tag',
			[
				'label' 	=> __( 'Subitle Tag', 'optech' ),
				'type' 		=> Controls_Manager::SELECT,
				'options' 	=> [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
					'p'  => 'P',
					'span'  => 'span',
				],
				'default' 	=> 'span',
			]
		);

		$this->add_control(
			'section_description',
			[
				'label' 	=> __( 'Section Description', 'optech' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Section Description', 'optech' )
			]
        );

        $this->add_responsive_control(
			'section_title_align',
			[
				'label' 		=> __( 'Alignment', 'optech' ),
				'type' 			=> Controls_Manager::CHOOSE,
				'options' 		=> [
					'left' 	=> [
						'title' 		=> __( 'Left', 'optech' ),
						'icon' 			=> 'eicon-text-align-left',
					],
					'center' 	=> [
						'title' 		=> __( 'Center', 'optech' ),
						'icon' 			=> 'eicon-text-align-center',
					],
					'right' 	=> [
						'title' 		=> __( 'Right', 'optech' ),
						'icon' 			=> 'eicon-text-align-right',
					],
				],
				'default' 	=> 'left',
				'toggle' 	=> true,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-default-content' => 'text-align: {{VALUE}};',
                ]
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
			'section_title_style_section',
			[
				'label' => __( 'Section Title Style', 'optech' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_control(
			'section_title_color',
			[
				'label'     => __( 'Section Title Color', 'optech' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-title' => 'color: {{VALUE}}',
				],
			]
		);		 
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'section_title_typography',
				'label'    => __( 'Section Title Typography', 'optech' ),
				'selector' => '{{WRAPPER}} .sec-title',
			]
		);		
        $this->add_responsive_control(
			'section_title_margin',
			[
				'label'        => __( 'Section Title Margin', 'optech' ),
				'type'         => Controls_Manager::DIMENSIONS,
				'size_units'   => [ 'px', '%', 'em' ],
				'selectors'    => [
					'{{WRAPPER}} .sec-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);		
		$this->add_control(
			'section_subtitle_color',
			[
				'label' 		=> __( 'Section Subtitle Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .sec-subtitle' => 'color: {{VALUE}}',
                ]
			]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'section_subtitle_typography',
				'label' 	=> __( 'Section Subtitle Typography', 'optech' ),
                'selector' 	=> '{{WRAPPER}} .sec-subtitle',
			]
        );
        $this->add_responsive_control(
			'section_subtitle_margin',
			[
				'label' 		=> __( 'Section Subtitle Margin', 'optech' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .sec-subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );
		$this->add_control(
			'section_description_color',
			[
				'label' 	=> __( 'Section Description Color', 'optech' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-text' => 'color: {{VALUE}}',
                ]
			]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'section_description_typography',
				'label' 	=> __( 'Section Description Typography', 'optech' ),
                'selector' 	=> '{{WRAPPER}} .sec-text',
			]
        );
        $this->add_responsive_control(
			'section_description_margin',
			[
				'label' 		=> __( 'Section Description Margin', 'optech' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .sec-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
		);
        $this->end_controls_section();

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		?>
			<div class="optech-default-content">
				<?php if ('yes' === $settings['show_image']) : ?>
					<div class="optech-hero-power">
						<img src="<?php echo esc_url( $settings['section_image']['url'] ); ?>" alt="Power Image">
					</div>
				<?php endif; ?>

				<?php if (!empty($settings['section_title'])) : ?>
					<?php echo '<' . esc_attr($settings['section_title_tag']) . ' class="sec-title">'; ?>
						<?php echo wp_kses_post($settings['section_title']); ?>
						<?php if (!empty($settings['section_title_two']) && $settings['section_title_style'] === '2') : ?>
							<span class="text-theme">
								<?php echo esc_html($settings['section_title_two']); ?>
							</span>
						<?php endif; ?>
					<?php echo '</' . esc_attr($settings['section_title_tag']) . '>'; ?>
				<?php endif; ?>

				<?php if (!empty($settings['section_subtitle'])) : ?>
					<?php echo '<' . esc_attr($settings['section_subtitle_tag']) . ' class="sec-subtitle">'; ?>
						<?php echo wp_kses_post($settings['section_subtitle']); ?>
					<?php echo '</' . esc_attr($settings['section_subtitle_tag']) . '>'; ?>
				<?php endif; ?>

				<?php if (!empty($settings['section_description'])) : ?>
					<?php echo optech_paragraph_tag(array(
						'text'  => wp_kses_post($settings['section_description']),
						'class' => 'sec-text'
					)); ?>
				<?php endif; ?>
			</div>
		<?php
	}
}
$widgets_manager->register( new \Optech_Section_Title_Widget() );