<div class="optech-portfolio-wrap">
    <div class="optech-portfolio-thumb">
        <?php if( has_post_thumbnail() ): ?>
            <?php the_post_thumbnail('full');?>
        <?php endif; ?>

        <?php if ( ! empty( $item['optech_project_icon']['value'] ) ) : ?>
            <a class="optech-portfolio-btn opp-custom-btn" href="<?php the_permalink(); ?>">
                <span class="p-btn-wraper">
                    <?php \Elementor\Icons_Manager::render_icon( $item['optech_project_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                </span>
            </a>
        <?php endif; ?>

        <div class="optech-portfolio-data optech-content">
            <a href="<?php the_permalink(); ?>">
                <h4><?php the_title(); ?></h4>
            </a>
            <p>
                <?php
                    $terms = get_the_terms(get_the_ID(), 'project_category');
                    if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
                        $term_names = array();
                        foreach ( $terms as $term ) {
                            $term_names[] = esc_html( $term->name );
                        }
                        echo implode(', ', $term_names);
                    }
                ?>
            </p>
        </div>
    </div>
</div>