<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Background;
/**
 *
 * Work Process Widget .
 *
 */
class Optech_Work_Process extends Widget_Base {

	public function get_name() {
		return 'optechworkprocess';
	}

	public function get_title() {
		return __( 'Work Process', 'optech' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'optech' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'work_process_section',
			[
				'label'		 	=> __( 'Work Process', 'optech' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'line_image',
			[
				'label' 		=> __( 'Line', 'optech' ),
				'type' 			=> Controls_Manager::MEDIA,
			]
		);

        $repeater = new Repeater();
		
		$repeater->add_control(
			'work_process_image',
			[
				'label' 		=> __( 'Choose Image', 'optech' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
        );
		$repeater->add_control(
			'work_process_step',
			[
				'label' => esc_html__( 'step', 'optech' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default'  	=> __( '01', 'optech' ),
			]
        );

        $repeater->add_control(
			'work_process_title',
			[
				'label' 	=> __( 'Title', 'optech' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'Initiation & Planning', 'optech' ),
			]
        );

		$repeater->add_control(
			'work_process_Dec',
			[
				'label' 	=> __( 'Description', 'optech' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Default description', 'optech' ),
				'placeholder' => __( 'Type your description here', 'optech' ),
			]
        );
		$this->add_control(
			'work_process_repeater',
			[
				'label' 		=> __( 'Work Process', 'optech' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' => [
					[
						'work_process_title' => __( 'List Item #1', 'elementor' ),
					],
					[
						'work_process_title' => __( 'List Item #2', 'elementor' ),
					],
					[
						'work_process_title' => __( 'List Item #3', 'elementor' ),
					],
				],
				'title_field' => '{{{ work_process_title }}}'
			]
		);
        $this->end_controls_section();

		// Style Section Start
        $this->start_controls_section(
			'work_process_box_style',
			[
				'label' => __( 'Box', 'optech' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'work_process_box_padding',
			[
				'label'      => __( 'Padding', 'optech' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
                    'top'      => '0',
                    'right'    => '0',
                    'bottom'   => '0',
                    'left'     => '0',
                    'unit'     => 'px',
                    'isLinked' => true
                ],
				'selectors'  => [
					'{{WRAPPER}} .optech-numberbox-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_responsive_control(
			'work_process_box_margin',
			[
				'label'      => __( 'Margin', 'optech' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
                    'top'      => '0',
                    'right'    => '0',
                    'bottom'   => '0',
                    'left'     => '0',
                    'unit'     => 'px',
                    'isLinked' => true
                ],
				'selectors'  => [
					'{{WRAPPER}} .optech-numberbox-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		$this->end_controls_section();
		//step
		$this->start_controls_section(
			'work_process_step_style',
			[
				'label' => __( 'Step', 'optech' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'step_color',
			[
				'label' => esc_html__( 'step Color', 'optech' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-numberbox-data h4' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'      => 'step_border',
				'selector'  => '{{WRAPPER}} .optech-numberbox-data span'
			]
		);

		$this->add_responsive_control(
			'step_border_radius',
			[
				'label'        => __( 'Border Radius', 'optech' ),
				'type'         => Controls_Manager::DIMENSIONS,
				'size_units'   => [ 'px', '%', 'em' ],
				'default'      => [
					'top'      => '0',
					'right'    => '0',
					'bottom'   => '0',
					'left'     => '0',
					'unit'     => 'px'
				],
				'selectors'    => [
					'{{WRAPPER}} .optech-numberbox-data span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		$this->end_controls_section();
		//Title
		$this->start_controls_section(
			'work_process_title_style',
			[
				'label' => __( 'Title', 'optech' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Title Color', 'optech' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-numberbox-data h4' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'work_process_title_typography',
				'label' => __( 'Typography', 'optech' ),
				'selector' => '{{WRAPPER}} .optech-numberbox-data h4',
			]
		);

		$this->add_responsive_control(
			'work_process_title_padding',
			[
				'label'      => __( 'padding', 'optech' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
                    'top'      => '0',
                    'right'    => '0',
                    'bottom'   => '0',
                    'left'     => '0',
                    'unit'     => 'px',
                    'isLinked' => true
                ],
				'selectors'  => [
					'{{WRAPPER}} .optech-numberbox-data h4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		$this->end_controls_section();

		//Text
		$this->start_controls_section(
			'work_process_text_style',
			[
				'label' => __( 'Text', 'optech' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'text_color',
			[
				'label' => esc_html__( 'Text Color', 'optech' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-numberbox-data p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'work_process_text_typography',
				'label' => __( 'Typography', 'optech' ),
				'selector' => '{{WRAPPER}} .optech-numberbox-data p',
			]
		);

		$this->add_responsive_control(
			'work_process_text_padding',
			[
				'label'      => __( 'padding', 'optech' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
                    'top'      => '0',
                    'right'    => '0',
                    'bottom'   => '0',
                    'left'     => '0',
                    'unit'     => 'px',
                    'isLinked' => true
                ],
				'selectors'  => [
					'{{WRAPPER}} .optech-numberbox-data p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		$this->end_controls_section();

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		?>
		<div class="row z-index">
			<?php foreach( $settings['work_process_repeater'] as $single_data ): ?>
				<div class="col-xl-4 col-md-6">
				<div class="optech-numberbox-wrap">
					<div class="optech-numberbox-icon">
					<img src="<?php echo esc_url( $single_data['work_process_image']['url'] ); ?>" alt="">
					</div>
					<div class="optech-numberbox-data">
					<span><?php echo esc_html( $single_data['work_process_step'] ); ?></span>
					<h4><?php echo esc_html( $single_data['work_process_title'] ); ?></h4>
					<p><?php echo esc_html( $single_data['work_process_Dec'] ); ?></p>
					</div>
				</div>
				</div>
			<?php endforeach; ?>
			<div class="optech-line">
				<img src="<?php echo esc_url( $settings['line_image']['url'] ); ?>" alt="">
        	</div>
    		</div>
		<?php
	}
}
$widgets_manager->register( new \Optech_Work_Process() );

