<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
/**
 *
 * Testimonial Slider Widget .
 *
 */
class Optech_Testimonial_Slider extends Widget_Base{

	public function get_name() {
		return 'optechtestimonialslider';
	}

	public function get_title() {
		return __( 'Testimonial Slider', 'optech' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'optech' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'testimonial_slider_section',
			[
				'label' 	=> __( 'Testimonial Slider', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'testimonial_style',
			[
				'label' 		=> __( 'Testimonial Style', 'optech' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '1',
				'options' 		=> [
					'1'  			=> __( 'Style One', 'optech' ),
					'2' 			=> __( 'Style Two', 'optech' ),
					'3' 			=> __( 'Style Three', 'optech' ),
				],
			]
		);

		$this->add_control(
			'show_slider_settings',
			[
				'label' => __( 'Slider?', 'optech' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'optech' ),
				'label_off' => __( 'Hide', 'optech' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);


		$this->add_responsive_control('per_line', [
            'label'              => __('Columns per row', 'optech'),  
            'type'               => \Elementor\Controls_Manager::SELECT,
            'default'            => '3',
            'tablet_default'     => '6',
            'mobile_default'     => '12',
            'options'            => [
                '12' => '1',
                '6'  => '2',
                '4'  => '3',
                '3'  => '4',
            ],
            'frontend_available' => true,
            'condition'   => [ 
				'show_slider_settings!' => 'yes',
			]
        ]);

		$this->add_responsive_control(
            'gap_bottom',
            [
                'label'          => __('Gap Bottom', 'optech'),
                'type'           => \Elementor\Controls_Manager::SLIDER,
                'size_units'     => ['px'],
                'range'          => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .optech-t-box3' => 'margin-bottom: {{SIZE}}{{UNIT}} !important;',
                    '{{WRAPPER}} .optech-t-box'  => 'margin-bottom: {{SIZE}}{{UNIT}} !important;',
                    '{{WRAPPER}} .optech-t-box2' => 'margin-bottom: {{SIZE}}{{UNIT}} !important;',
                ],
				'condition'   => [ 
				'show_slider_settings!' => 'yes',
			]
            ]
        );

		$repeater = new Repeater();

		$repeater->add_control(
			'quate',
			[
				'label' 		=> __( 'Quote', 'optech' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'optech' ),
				'label_off' 	=> __( 'No', 'optech' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
		$repeater->add_control(
			'quate_image',
			[
				'label' 		=> __( 'Quote Icon', 'optech' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
				'condition' => [
					'quate' => 'yes',
				]
			]
        );
		$repeater->add_control(
			'client_text', [
				'label' 		=> __( 'Client Text', 'optech' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( '“ Working with several word press themes and templates the last years, I only can say this is best in every level. I use it for my company and the reviews that I have already are all excellent. Not only the design but the code quality ”' , 'optech' ),
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'rating',
			[
				'label' 		=> __( 'Rating?', 'optech' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'optech' ),
				'label_off' 	=> __( 'No', 'optech' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
		$repeater->add_control(
			'rating_icon',
			[
				'label' => __( 'Ratting Icon', 'optech' ),
				'type' => Controls_Manager::ICONS,
				'default' => [
					'value' => 'remixicon ri-star-fill',
					'library' => 'remixicon',
				],
				'condition' => [
					'rating' => 'yes',
				]
			]
		);

		$repeater->add_control(
			'client_name', [
				'label' 		=> __( 'Client Name', 'optech' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Alexander Cameron' , 'optech' ),
				'label_block' 	=> true,
			]
        );
		$repeater->add_control(
			'client_designation', [
				'label' 		=> __( 'Client Name', 'optech' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Lead Developer' , 'optech' ),
				'label_block' 	=> true,
			]
        );
		$this->add_control(
			'slides',
			[
				'label' 		=> __( 'Slides', 'optech' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
			]
		);
		$this->end_controls_section();
		// Slider Setting
		$this->start_controls_section(
			'slider_settings',
			[
			'label' => __('Slider Settings', 'optech'),
			'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			'condition'   => [ 
				'show_slider_settings' => 'yes',
			]
			]
		);
		$this->add_responsive_control(
            'per_coulmn',
            [
                'label' => __( 'Slider Items', 'optech' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default'            => 2,
                'tablet_default'     => 1,
                'mobile_default'     => 1,
                'options'            => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                ],
				'condition' => [
					'testimonial_style' => ['1', '3'],
					
				],
                'frontend_available' => true,
            ]
        );
		$this->add_control(
			'arrows',
			[
				'label' => __( 'Arrows?', 'optech' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'optech' ),
				'label_off' => __( 'Hide', 'optech' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [
					'testimonial_style' => '2',
				],
			]
		);
		$this->add_control(
			'dots',
			[
				'label' => __( 'Dots?', 'optech' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'optech' ),
				'label_off' => __( 'Hide', 'optech' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [
					'testimonial_style' => ['1', '3'],
				],
				
			]
		);
		$this->add_control(
			'drag',
			[
				'label' => __( 'Drag?', 'optech' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'optech' ),
				'label_off' => __( 'Hide', 'optech' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'autoplay',
			[
				'label' => __( 'Auto Play?', 'optech' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'optech' ),
				'label_off' => __( 'Hide', 'optech' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'autoplaytimeout',
			[
				'label' => __( 'Autoplay Timeout', 'optech' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'label_block' => true,
				'default' => '5000',
				'options' => [
					'1000'  => __( '1 Second', 'optech' ),
					'2000'  => __( '2 Second', 'optech' ),
					'3000'  => __( '3 Second', 'optech' ),
					'4000'  => __( '4 Second', 'optech' ),
					'5000'  => __( '5 Second', 'optech' ),
					'6000'  => __( '6 Second', 'optech' ),
					'7000'  => __( '7 Second', 'optech' ),
					'8000'  => __( '8 Second', 'optech' ),
					'9000'  => __( '9 Second', 'optech' ),
					'10000' => __( '10 Second', 'optech' ),
					'11000' => __( '11 Second', 'optech' ),
					'12000' => __( '12 Second', 'optech' ),
					'13000' => __( '13 Second', 'optech' ),
					'14000' => __( '14 Second', 'optech' ),
					'15000' => __( '15 Second', 'optech' ),
				],
				'condition' => [
					'autoplay' => 'yes',
				],
			]
		);
		$this->end_controls_section();
		// End Slider settings
		// Style section start  
		$this->start_controls_section(
			'quote_style',
			[
				'label' 	=> __( 'Quote Image', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
		$this->add_responsive_control(
			'quote_width',
			[
				'label' => __( 'Width', 'optech' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .optech-t-quote img' => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .optech-t-quote2 img' => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .optech-t-quote3 img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

		// Box Style 
		$this->start_controls_section(
			'box_style',
			[
				'label' 	=> __( 'Box', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
		$this->add_control(
			'box_bg_color',
			[
				'label' 		=> __( 'Background Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-t-box' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .optech-t-box2' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} ..optech-t-box3' => 'background-color: {{VALUE}}',
                ],
			]
        );
		$this->add_responsive_control(
			'box_padding',
			[
				'label' 		=> __( 'Padding', 'optech' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .optech-t-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .optech-t-box2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .optech-t-box3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'box_border',
				'label' 	=> __( 'Border', 'optech' ),
                'selector' 	=> '{{WRAPPER}} .optech-t-box, {{WRAPPER}} .optech-t-box2, {{WRAPPER}} .optech-t-box3',
			]
		);
		$this->add_responsive_control(
			'box_border_radius',
			[
				'label' 		=> __( 'Border Radius', 'optech' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .optech-t-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .optech-t-box2' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .optech-t-box3' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
			]
		);
		$this->end_controls_section();

		// Text Style 
		$this->start_controls_section(
			'text_style',
			[
				'label' 	=> __( 'Text', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
		$this->add_control(
			'text_color',
			[
				'label' 		=> __( 'Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-t-data p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .optech-t-data2 p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .optech-t-data3 p' => 'color: {{VALUE}}',
                ],
			]
        );
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'text_typography',
				'label' 	=> __( 'Typography', 'optech' ),
				'selector' 	=> '{{WRAPPER}} .optech-t-data p, {{WRAPPER}} .optech-t-data2 p, {{WRAPPER}} .optech-t-data3 p',
			]
        );
		$this->add_responsive_control(
			'text_margin',
			[
				'label'        => __( 'Margin', 'optech' ),
				'type'         => Controls_Manager::DIMENSIONS,
				'size_units'   => [ 'px', '%', 'em' ],
				'selectors'    => [
					'{{WRAPPER}} .optech-t-data p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .optech-t-data2 p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .optech-t-data3 p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		$this->end_controls_section();

		// Rating Style 
		$this->start_controls_section(
			'rating_style',
			[
				'label' 	=> __( 'Rating', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
		$this->add_control(
			'rating_color',
			[
				'label' 		=> __( 'Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-t-rating ul li i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .optech-t-rating2 ul li i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .optech-t-rating3 ul li i' => 'color: {{VALUE}}',
                ],
			]
        );
		$this->add_responsive_control(
			'rating_size',
			[
				'label' => __( 'Font Size', 'optech' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .optech-t-rating ul li i' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .optech-t-rating2 ul li i' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .optech-t-rating3 ul li i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

		// Name Style 
		$this->start_controls_section(
			'name_style',
			[
				'label' 	=> __( 'Name', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
		$this->add_control(
			'name_color',
			[
				'label' 		=> __( 'Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-t-author h5' => 'color: {{VALUE}}',
					'{{WRAPPER}} .optech-t-data2 h5' => 'color: {{VALUE}}',
                ],
			]
        );
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'name_typography',
				'label' 	=> __( 'Typography', 'optech' ),
                'selector' 	=> '{{WRAPPER}} .optech-t-author h5, {{WRAPPER}} .optech-t-data2 h5',
			]
        );
		$this->add_responsive_control(
			'name_margin',
			[
				'label'        => __( 'Margin', 'optech' ),
				'type'         => Controls_Manager::DIMENSIONS,
				'size_units'   => [ 'px', '%', 'em' ],
				'selectors'    => [
					'{{WRAPPER}} .optech-t-author h5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .optech-t-data2 h5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		$this->end_controls_section();

		// Designation Style 
		$this->start_controls_section(
			'designation_style',
			[
				'label' 	=> __( 'Designation', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
		$this->add_control(
			'designation_color',
			[
				'label' 		=> __( 'Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-t-author span' => 'color: {{VALUE}}',
					'{{WRAPPER}} .optech-t-data2 span' => 'color: {{VALUE}}',
                ],
			]
        );
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'designation_typography',
				'label' 	=> __( 'Typography', 'optech' ),
                'selector' 	=> '{{WRAPPER}} .optech-t-author span, {{WRAPPER}} .optech-t-data2 span',
			]
        );
		$this->end_controls_section();


	}
	protected function render() {

		$settings = $this->get_settings_for_display();

		$testimonial_style = $settings[ 'testimonial_style' ];

		//this code course slider option
		$slider_extraSetting = array(
			'autoplay' => (!empty($settings['autoplay']) && 'yes' === $settings['autoplay']) ? true : false,
			'drag' => (!empty($settings['drag']) && 'yes' === $settings['drag']) ? true : false,
			'dots' => (!empty($settings['dots']) && 'yes' === $settings['dots']) ? true : false,
			'arrows' => (!empty($settings['arrows']) && 'yes' === $settings['arrows']) ? true : false,
			'autoplaytimeout' => !empty($settings['autoplaytimeout']) ? $settings['autoplaytimeout'] : '5000',

			//this a responsive layout
			'per_coulmn' =>        (!empty($settings['per_coulmn'])) ? $settings['per_coulmn'] : 1,
			'per_coulmn_tablet' => (!empty($settings['per_coulmn_tablet'])) ? $settings['per_coulmn_tablet'] : 1,
			'per_coulmn_mobile' => (!empty($settings['per_coulmn_mobile'])) ? $settings['per_coulmn_mobile'] : 1
		);
	   
		$jasondecode = wp_json_encode($slider_extraSetting);

		if( 'yes' == $settings['show_slider_settings'] ){
			if('1' == $testimonial_style){
				$this->add_render_attribute('slider_attributes', 'class', ['optech-2column-slider testi-slider-active']);
			}elseif('2' == $testimonial_style){
				$this->add_render_attribute('slider_attributes', 'class', ['optech-1column-slider testi-slider-active']);
			}else{
				$this->add_render_attribute('slider_attributes', 'class', ['optech-3column-slider2 testi-slider-active']);
			}
			//slider attributes data load
			$this->add_render_attribute('slider_attributes', 'data-settings', $jasondecode);
		}else{
			//gride class
            $grid_classes = [];
            $grid_classes[] = 'col-xl-' . $settings['per_line'];
            $grid_classes[] = 'col-md-' . $settings['per_line_tablet'];
            $grid_classes[] = 'col-sm-' . $settings['per_line_mobile'];
            $grid_classes = implode(' ', $grid_classes);
            $this->add_render_attribute('testimonial_gride_classes', 'class', [$grid_classes]);
			if('1' == $testimonial_style){
				$this->add_render_attribute('slider_attributes', 'class', ['row optech-2column-slider  ']);
			}elseif('2' == $testimonial_style){
				$this->add_render_attribute('slider_attributes', 'class', ['row optech-1column-slider  ']);
			}else{
				$this->add_render_attribute('slider_attributes', 'class', ['row optech-3column-slider2  ']);
			}
		}
		


		

		

		


		?>
			<?php 	
				if ($testimonial_style) {
					include('testimonial/'.$testimonial_style.'.php');
				}
			?>
		<?php 
	}
}
$widgets_manager->register( new \Optech_Testimonial_Slider() );
