<?php

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Control_Media;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Icons_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Widget_Base;

class Optech_List_group extends Widget_Base {

	public function get_name() {
		return 'optech-footer-menus';
	}

	public function get_title() {
		return esc_html__( 'List Group', 'optech' );
	}

	public function get_icon() {
		return 'eicon-editor-list-ol optech';
	}

	public function get_categories() {
		return [ 'optech' ];
	}

	public function get_keywords() {
		return [ 'optech', 'information', 'group', 'list', 'icon', 'social' ];
	}

	protected function register_controls() {

		/*
		* Icon List Content
		*/
		$this->start_controls_section(
			'optech_section_list_content',
			[
				'label' => esc_html__( 'Content', 'optech' )
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
            'optech_list_icon_type',
            [
                'label' => __( 'Media Type', 'optech' ),
                'type' => Controls_Manager::CHOOSE,
                'default' => 'icon',
				'options' => [
					'icon' => [
						'title' => __( 'Icon', 'optech' ),
						'icon' => 'eicon-star',
					],
					'number' => [
						'title' => __( 'Number', 'optech' ),
						'icon' => 'eicon-number-field',
					],
					'image' => [
						'title' => __( 'Image', 'optech' ),
						'icon' => 'eicon-image',
					],
				],
				'toggle' => false,
                'style_transfer' => true,
            ]
        );

		$repeater->add_control(
			'optech_list_icon',
			[
				'label'       => __( 'Icon', 'optech' ),
				'type'        => Controls_Manager::ICONS,
				'label_block' => true,
				'separator'   =>'after',
				'default'     => [
					'value'   => 'far fa-check-circle',
					'library' => 'fa-regular'
				],
				'condition' =>[
					'optech_list_icon_type' => 'icon'
				]
			]
		);

		$repeater->add_control(
			'optech_list_icon_number',
			[
				'label'   => esc_html__( 'Number', 'optech' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( '1', 'optech' ),
				'separator'   =>'after',
				'condition' =>[
					'optech_list_icon_type' => 'number'
				]
			]
		);

		$repeater->add_control(
			'optech_list_icon_number_image',
			[
				'label' => __( 'Choose Image', 'optech' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'separator'   =>'after',
				'dynamic' => [
					'active' => true,
				],
				'condition' =>[
					'optech_list_icon_type' => 'image'
				]
			]
		);

        $repeater->add_control(
			'optech_list_text',
			[
				'label'   => esc_html__( 'Text', 'optech' ),
				'type'    => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => esc_html__( 'List Text', 'optech' ),
				'dynamic' => [ 'active' => true ]
			]
		);

		$repeater->add_control(
			'optech_list_link',
			[
				'label' => __( 'List URL', 'optech' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'optech' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);

		$this->add_control(
			'optech_list_group',
			[
				'label' => __( 'List Items', 'elementor' ),
				'type' 		=> Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
				'default' => [
					[
						'optech_list_text' => __( 'List Item #1', 'elementor' ),
						'optech_list_icon' => [
							'value' => 'fas fa-check',
							'library' => 'fa-solid',
						],
					],
					[
						'optech_list_text' => __( 'List Item #2', 'elementor' ),
						'optech_list_icon' => [
							'value' => 'fas fa-check',
							'library' => 'fa-solid',
						],
					],
					[
						'optech_list_text' => __( 'List Item #3', 'elementor' ),
						'optech_list_icon' => [
							'value' => 'fas fa-check',
							'library' => 'fa-solid',
						],
					],
				],
				'title_field' => '{{{ elementor.helpers.renderIcon( this, optech_list_icon, {}, "i", "panel" ) }}}{{{ optech_list_text }}}'
			]
		);

		$this->end_controls_section();

		/*
		* Icon List Content
		*/
		$this->start_controls_section(
			'optech_section_list_style',
			[
				'label' => esc_html__( 'Container', 'optech' ),
				'tab'   => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_control(
			'optech_section_list_layout',
			[
				'label' => __( 'Layout', 'optech' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'layout_1',
				'options' => [
					'layout_1' => __( 'Layout 1', 'optech' ),
					'layout_2' => __( 'Layout 2', 'optech' ),
					'layout_3' => __( 'Layout 3', 'optech' ),
				],
			]
		);

		$this->add_responsive_control(
			'optech_section_list_alignment',
			[
				'label'       => esc_html__( 'Alignment', 'optech' ),
				'type'        => Controls_Manager::CHOOSE,
				'toggle'      => false,
				'label_block' => false,
				'options'     => [
					'optech-footer-menu-left'   => [
						'title' => esc_html__( 'Left', 'optech' ),
						'icon'  => 'eicon-text-align-left'
					],
					'optech-footer-menu-center' => [
						'title' => esc_html__( 'Center', 'optech' ),
						'icon'  => 'eicon-text-align-center'
					],
					'optech-footer-menu-right'  => [
						'title' => esc_html__( 'Right', 'optech' ),
						'icon'  => 'eicon-text-align-right'
					]
				],
				'selectors_dictionary' => [
					'optech-footer-menu-left' => 'justify-content: flex-start; text-align: left;',
					'optech-footer-menu-center' => 'justify-content: center; text-align: center;',
					'optech-footer-menu-right' => 'justify-content: flex-end; text-align: right;',
				],
				'selectors' => [
					'{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper' => '{{VALUE}};',
					'{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper .optech-footer-menu-item' => '{{VALUE}};',
					'{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper .optech-footer-menu-item a' => '{{VALUE}};',
				],
				'default'     => 'optech-footer-menu-left',
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'            => 'optech_section_list_group_background',
				'types'           => [ 'classic', 'gradient' ],
				'selector'        => '{{WRAPPER}} .optech-footer-menu',
			]
		);

		$this->add_responsive_control(
			'optech_section_list_group_padding',
			[
				'label'      => __( 'Padding', 'optech' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
                    'top'      => '0',
                    'right'    => '0',
                    'bottom'   => '0',
                    'left'     => '0',
                    'unit'     => 'px',
                    'isLinked' => true
                ],
				'selectors'  => [
					'{{WRAPPER}} .optech-footer-menu' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'      => 'optech_section_list_group_border',
				'selector'  => '{{WRAPPER}} .optech-footer-menu'
			]
		);

		$this->add_responsive_control(
			'optech_section_list_group_radius',
			[
				'label'        => __( 'Border Radius', 'optech' ),
				'type'         => Controls_Manager::DIMENSIONS,
				'size_units'   => [ 'px', '%', 'em' ],
				'default'      => [
					'top'      => '0',
					'right'    => '0',
					'bottom'   => '0',
					'left'     => '0',
					'unit'     => 'px'
				],
				'selectors'    => [
					'{{WRAPPER}} .optech-footer-menu' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'optech_section_list_group_shadow',
				'selector' => '{{WRAPPER}} .optech-footer-menu'
			]
		);

		$this->end_controls_section();

		/*
		* Icon List Content
		*/
		$this->start_controls_section(
			'optech_section_list_item_style',
			[
				'label' => esc_html__( 'List Item', 'optech' ),
				'tab'   => Controls_Manager::TAB_STYLE
			]
		);
        $this->add_responsive_control(
			'optech_section_list_item_margin',
			[
				'label'        => __( 'Item Margin', 'optech' ),
				'type'         => Controls_Manager::DIMENSIONS,
				'size_units'   => [ 'px', '%', 'em' ],
				'default'      => [
					'top'      => '0',
					'right'    => '0',
					'bottom'   => '0',
					'left'     => '0',
					'unit'     => 'px'
				],
				'selectors'    => [
					'{{WRAPPER}} .optech-footer-menu ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_control(
			'optech_section_list_item_separator',
            [
				'label'        => __( 'Item Separator', 'optech' ),
				'type'         =>  Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'optech' ),
				'label_off'    => __( 'Hide', 'optech' ),
				'return_value' => 'yes',
				'default'      => 'no',
				'condition'    => [
					'optech_section_list_layout' => 'layout_3'
				]
			]
        );

		$this->add_responsive_control(
			'optech_section_list_item_separator_height',
			[
				'label' => __( 'Separator Height', 'optech' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 10,
						'step' => 1,
					]
				],
				'default' => [
					'unit' => 'px',
					'size' => 1,
				],
				'selectors' => [
					'{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper.layout_1 .optech-footer-menu-item:not(:last-child):after' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper.layout_2 .optech-footer-menu-item:not(:last-child):after' => 'width: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'optech_section_list_item_separator' => 'yes',
					'optech_section_list_layout' => 'layout_3'
				]
			]
		);

		$this->add_control(
			'optech_section_list_item_separator_color',
			[
				'label' => __( 'Separator Color', 'optech' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#e5e5e5',
				'selectors' => [
					'{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper.layout_1 .optech-footer-menu-item:not(:last-child):after' => 'background: {{VALUE}}',
					'{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper.layout_2 .optech-footer-menu-item:not(:last-child):after' => 'background: {{VALUE}}',
				],
				'condition' => [
					'optech_section_list_item_separator' => 'yes',
					'optech_section_list_layout' => 'layout_3'
				]
			]
		);

		$this->add_responsive_control(
			'optech_list_item_spacing',
			[
				'label' => __( 'Item Spacing', 'optech' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
						'step' => 1,
					]
				],
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'selectors' => [
					'{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper.layout_3 .optech-footer-menu-item:not(:last-child)' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'optech_section_list_layout' => 'layout_3'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'            => 'optech_list_item_background',
				'types'           => [ 'classic', 'gradient' ],
				'selector'        => '{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper.layout_3 .optech-footer-menu-item',
				'condition' => [
					'optech_section_list_layout' => 'layout_3'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'      => 'optech_list_item_border',
				'selector'  => '{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper.layout_3 .optech-footer-menu-item',
				'fields_options'  => [
                    'border' 	  => [
                        'default' => 'solid'
                    ],
                    'width'  	  => [
                        'default' 	 => [
                            'top'    => '1',
                            'right'  => '1',
                            'bottom' => '1',
                            'left'   => '1'
                        ]
                    ],
                    'color' 	  => [
                        'default' => '#e5e5e5',
                    ]
                ],
				'condition' => [
					'optech_section_list_layout' => 'layout_3'
				]
			]
		);

		$this->add_responsive_control(
			'optech_list_item_radius',
			[
				'label'        => __( 'Border Radius', 'optech' ),
				'type'         => Controls_Manager::DIMENSIONS,
				'size_units'   => [ 'px', '%', 'em' ],
				'default'      => [
					'top'      => '10',
					'right'    => '10',
					'bottom'   => '10',
					'left'     => '10',
					'unit'     => 'px'
				],
				'selectors'    => [
					'{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper.layout_3 .optech-footer-menu-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
				'condition' => [
					'optech_section_list_layout' => 'layout_3'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'optech_list_item_shadow',
				'selector' => '{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper.layout_3 .optech-footer-menu-item',
				'condition' => [
					'optech_section_list_layout' => 'layout_3'
				]
			]
		);

		$this->end_controls_section();

		/*
		* Icon List Icon Style
		*/
		$this->start_controls_section(
			'optech_section_list_icon_style',
			[
				'label' => esc_html__( 'Icon', 'optech' ),
				'tab'   => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_responsive_control(
			'optech_list_icon_position',
			[
				'label'       => esc_html__( 'Icon Position', 'optech' ),
				'type'        => Controls_Manager::CHOOSE,
				'toggle'      => false,
				'label_block' => false,
				'options'     => [
					'optech-icon-left'   => [
						'title' => esc_html__( 'Left', 'optech' ),
						'icon'  => 'eicon-h-align-left'
					],
					'optech-icon-center' => [
						'title' => esc_html__( 'Center', 'optech' ),
						'icon'  => 'eicon-v-align-top'
					],
					'optech-icon-right'  => [
						'title' => esc_html__( 'Right', 'optech' ),
						'icon'  => 'eicon-h-align-right'
					]
				],
				'default'     => 'optech-icon-left'
			]
		);

		$this->add_responsive_control(
			'optech_list_icon_alignment',
			[
				'label'       => esc_html__( 'Icon Vertical Alignment', 'optech' ),
				'type'        => Controls_Manager::CHOOSE,
				'toggle'      => false,
				'label_block' => false,
				'options'     => [
					'optech-icon-align-left'   => [
						'title' => esc_html__( 'Top', 'optech' ),
						'icon'  => 'eicon-v-align-top'
					],
					'optech-icon-align-center' => [
						'title' => esc_html__( 'Center', 'optech' ),
						'icon'  => 'eicon-v-align-middle'
					],
					'optech-icon-align-right'  => [
						'title' => esc_html__( 'Bottom', 'optech' ),
						'icon'  => 'eicon-v-align-bottom'
					]
				],
				'default'     => 'optech-icon-align-left',
				'selectors_dictionary' => [
					'optech-icon-align-left' => 'align-items: flex-start;',
					'optech-icon-align-center' => 'align-items: center;',
					'optech-icon-align-right' => 'align-items: flex-end;',
				],
				'selectors' => [
					'{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper .optech-footer-menu-item' => '{{VALUE}};',
				],
				'condition' => [
					'optech_list_icon_position!' => 'optech-icon-center'
				]
			]
		);

		$this->add_responsive_control(
			'optech_list_icon_top_alignment',
			[
				'label'       => esc_html__( 'Icon Alignment', 'optech' ),
				'type'        => Controls_Manager::CHOOSE,
				'toggle'      => false,
				'label_block' => false,
				'options'     => [
					'optech-icon-top-align-left'   => [
						'title' => esc_html__( 'Left', 'optech' ),
						'icon'  => 'eicon-v-align-top'
					],
					'optech-icon-top-align-center' => [
						'title' => esc_html__( 'Center', 'optech' ),
						'icon'  => 'eicon-v-align-middle'
					],
					'optech-icon-top-align-right'  => [
						'title' => esc_html__( 'Right', 'optech' ),
						'icon'  => 'eicon-v-align-bottom'
					]
				],
				'default'     => 'optech-icon-left',
				'selectors_dictionary' => [
					'optech-icon-top-align-left' => 'text-align: left; margin-right: auto;',
					'optech-icon-top-align-center' => 'text-align: center; margin-left: auto; margin-right: auto;',
					'optech-icon-top-align-right' => 'text-align: right; margin-left: auto;',
				],
				'selectors' => [
					'{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper .optech-footer-menu-item .optech-footer-menu-icon' => '{{VALUE}};',
					'{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper .optech-footer-menu-item .optech-footer-menu-icon .optech-footer-menu-icon-image' => '{{VALUE}};',
				],
				'condition' => [
					'optech_list_icon_position' => 'optech-icon-center'
				]
			]
		);

		$this->add_responsive_control(
			'optech_section_list_item_icon_spacing',
			[
				'label' => __( 'Icon Right Spacing', 'optech' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					]
				],
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'selectors' => [
					'{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper .optech-footer-menu-item .optech-footer-menu-text' => 'padding-left: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'optech_list_icon_position' => 'optech-icon-left'
				]
			]
		);

		$this->add_responsive_control(
			'optech_section_list_item_icon_margin_bottom',
			[
				'label' => __( 'Icon Bottom Spacing', 'optech' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					]
				],
				'default' => [
					'unit' => 'px',
					'size' => 0,
				],
				'selectors' => [
					'{{WRAPPER}} .optech-footer-menu-icon' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'optech_section_list_item_icon_left_spacing',
			[
				'label' => __( 'Icon Left Spacing', 'optech' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					]
				],
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'selectors' => [
					'{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper .optech-footer-menu-item .optech-footer-menu-icon' => 'margin-left: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'optech_list_icon_position' => 'optech-icon-right'
				]
			]
		);
		$this->add_responsive_control(
			'optech_section_list_item_icon_bottom_spacing',
			[
				'label' => __( 'Icon Bottom Spacing', 'optech' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					]
				],
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'selectors' => [
					'{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper .optech-footer-menu-item .optech-footer-menu-icon' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'optech_list_icon_position' => 'optech-icon-center'
				]
			]
		);

		$this->add_responsive_control(
			'optech_section_list_item_icon_size',
			[
				'label' => __( 'Icon Size', 'optech' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					]
				],
				'default' => [
					'unit' => 'px',
					'size' => 16,
				],
				'selectors' => [
					'{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper .optech-footer-menu-item .optech-footer-menu-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper .optech-footer-menu-item .optech-footer-menu-icon svg' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper .optech-footer-menu-item .optech-footer-menu-icon .optech-footer-menu-icon-image' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'optech_section_list_item_icon_color',
			[
				'label' => __( 'Icon Color', 'optech' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper .optech-footer-menu-item .optech-footer-menu-icon i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper .optech-footer-menu-item .optech-footer-menu-icon svg path' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'optech_section_list_item_icon_color_hover',
			[
				'label' => __( 'Icon Color Hover', 'optech' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper .optech-footer-menu-item .optech-footer-menu-icon:hover i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper .optech-footer-menu-item .optech-footer-menu-icon:hover svg path' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'optech_section_list_item_icon_bg_color_hover',
			[
				'label' => __( 'Icon Background Hover', 'optech' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper .optech-footer-menu-item .optech-footer-menu-icon.yes:hover' => 'background-color: {{VALUE}} !important',
				],
			]
		);

		$this->add_control(
			'optech_section_list_item_icon_border color_hover',
			[
				'label' => __( 'Icon Border Hover', 'optech' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper .optech-footer-menu-item .optech-footer-menu-icon.yes:hover' => 'border-color: {{VALUE}} !important',
				],
			]
		);


		$this->add_responsive_control(
			'optech_section_list_item_image_radius',
			[
				'label'        => __( 'Image Radius', 'optech' ),
				'type'         => Controls_Manager::DIMENSIONS,
				'size_units'   => [ 'px', '%', 'em' ],
				'default'      => [
					'top'      => '0',
					'right'    => '0',
					'bottom'   => '0',
					'left'     => '0',
					'unit'     => 'px'
				],
				'selectors'    => [
					'{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper .optech-footer-menu-item .optech-footer-menu-icon .optech-footer-menu-icon-image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
			]
		);

		$this->add_control(
			'optech_list_item_icon_box_enable',
			[
				'label' => __( 'Enable Icon Box', 'optech' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'optech' ),
				'label_off' => __( 'Hide', 'optech' ),
				'return_value' => 'yes',
				'default' => 'no',
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'optech_list_item_icon_box_width',
			[
				'label' => __( 'Icon Box Width', 'optech' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					]
				],
				'default' => [
					'unit' => 'px',
					'size' => 40,
				],
				'selectors' => [
					'{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper .optech-footer-menu-item .optech-footer-menu-icon.yes' => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper.layout_1 .optech-footer-menu-item .optech-footer-menu-text' => 'width: calc( 100% - {{SIZE}}{{UNIT}} );',
					'{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper.layout_2 .optech-footer-menu-item .optech-footer-menu-text' => 'width: calc( 100% - {{SIZE}}{{UNIT}} );',
					'{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper.layout_3 .optech-footer-menu-item .optech-footer-menu-text' => 'width: calc( 100% - {{SIZE}}{{UNIT}} );',
				],
				'condition' => [
					'optech_list_item_icon_box_enable' => 'yes'
				]
			]
		);

		$this->add_responsive_control(
			'optech_list_item_icon_box_height',
			[
				'label' => __( 'Icon Box Height', 'optech' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					]
				],
				'default' => [
					'unit' => 'px',
					'size' => 40,
				],
				'selectors' => [
					'{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper .optech-footer-menu-item .optech-footer-menu-icon.yes' => 'height: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'optech_list_item_icon_box_enable' => 'yes'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'            => 'optech_list_item_icon_box_background',
				'types'           => [ 'classic', 'gradient' ],
				'selector'        => '{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper .optech-footer-menu-item .optech-footer-menu-icon.yes',
				'condition' => [
					'optech_list_item_icon_box_enable' => 'yes'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'            => 'optech_list_item_icon_box_background_hover',
				'types'           => [ 'classic', 'gradient' ],
				'selector'        => '{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper .optech-footer-menu-item .optech-footer-menu-icon.yes:hover',
				'condition' => [
					'optech_list_item_icon_box_enable' => 'yes'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'      => 'optech_list_item_icon_box_border',
				'selector'  => '{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper .optech-footer-menu-item .optech-footer-menu-icon.yes',
				'condition' => [
					'optech_list_item_icon_box_enable' => 'yes'
				]
			]
		);

		$this->add_responsive_control(
			'optech_list_item_icon_box_radius',
			[
				'label'        => __( 'Border Radius', 'optech' ),
				'type'         => Controls_Manager::DIMENSIONS,
				'size_units'   => [ 'px', '%', 'em' ],
				'default'      => [
					'top'      => '0',
					'right'    => '0',
					'bottom'   => '0',
					'left'     => '0',
					'unit'     => 'px'
				],
				'selectors'    => [
					'{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper .optech-footer-menu-item .optech-footer-menu-icon.yes' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
				'condition' => [
					'optech_list_item_icon_box_enable' => 'yes'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'optech_list_item_icon_box_shadow',
				'selector' => '{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper .optech-footer-menu-item .optech-footer-menu-icon.yes',
				'condition' => [
					'optech_list_item_icon_box_enable' => 'yes'
				]
			]
		);

		$this->end_controls_section();

		/*
		* Icon List Text
		*/
		$this->start_controls_section(
			'optech_section_list_text_style',
			[
				'label' => esc_html__( 'Text', 'optech' ),
				'tab'   => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_responsive_control(
			'optech_section_list_text_alignment',
			[
				'label'       => esc_html__( 'Text Alignment', 'optech' ),
				'type'        => Controls_Manager::CHOOSE,
				'toggle'      => false,
				'label_block' => false,
				'options'     => [
					'optech-text-align-left'   => [
						'title' => esc_html__( 'Left', 'optech' ),
						'icon'  => 'eicon-text-align-left'
					],
					'optech-text-align-center' => [
						'title' => esc_html__( 'Center', 'optech' ),
						'icon'  => 'eicon-text-align-left'
					],
					'optech-text-align-right'  => [
						'title' => esc_html__( 'Right', 'optech' ),
						'icon'  => 'eicon-text-align-left'
					]
				],
				'default'     => 'optech-text-align-left',
				'selectors_dictionary' => [
					'optech-text-align-left' => 'text-align: left;',
					'optech-text-align-center' => 'text-align: center;',
					'optech-text-align-right' => 'text-align: right;',
				],
				'selectors' => [
					'{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper .optech-footer-menu-item .optech-footer-menu-text' => '{{VALUE}};',
				],
				'condition' => [
					'optech_list_icon_position' => 'optech-icon-center'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'optech_section_list_text_typography',
				'label' => __( 'Typography', 'optech' ),
				'selector' => '{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper .optech-footer-menu-item .optech-footer-menu-text',
			]
		);

		$this->add_control(
			'optech_section_list_text_color',
			[
				'label' => __( 'Text Color', 'optech' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper .optech-footer-menu-item .optech-footer-menu-text' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'optech_section_list_text_hover_color',
			[
				'label' => __( 'Text Color Hover', 'optech' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-footer-menu .optech-footer-menu-wrapper .optech-footer-menu-item .optech-footer-menu-text:hover' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_control(
			'optech_section_list_text_underline_color',
			[
				'label' => __( 'Underline Color', 'optech' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-footer-menu.dark-color ul li a:before' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();

	}
	protected function render() {
		$settings = $this->get_settings_for_display();

		?>
            <div class="optech-footer-menu dark-color">
                <ul class="optech-footer-menu-wrapper <?php echo $settings['optech_section_list_layout']; ?>">
                    <?php foreach( $settings['optech_list_group'] as $list ) : ?>
                    <?php
                        $target = $list['optech_list_link']['is_external'] ? ' target="_blank"' : '';
                        $nofollow = $list['optech_list_link']['nofollow'] ? ' rel="nofollow"' : '';
                    ?>
                        <li class="optech-footer-menu-item <?php echo $settings['optech_list_icon_position']?>">
                            <?php if ( !empty( $list['optech_list_link']['url'] ) ) { ?>
                            <a href="<?php echo $list['optech_list_link']['url']; ?>" <?php echo $target; ?> <?php echo $nofollow; ?> >
                            <?php } ?>
                                <div class="optech-footer-menu-icon <?php echo $settings['optech_list_item_icon_box_enable']; ?>">
                                    <?php if ( $list['optech_list_icon_type'] === 'icon' && !empty($list['optech_list_icon']) ){ ?>
                                        <?php Icons_Manager::render_icon( $list['optech_list_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                    <?php } ?>
                                    <?php if ( $list['optech_list_icon_type'] === 'number' && !empty($list['optech_list_icon_type']) ){ ?>
                                        <div class="optech-footer-menu-icon-number">
                                            <?php echo $list['optech_list_icon_number']; ?>
                                        </div>
                                    <?php } ?>
                                    <?php if ( $list['optech_list_icon_type'] === 'image' && !empty($list['optech_list_icon_type']) ){ ?>
                                        <div class="optech-footer-menu-icon-image">
                                            <img src="<?php echo $list['optech_list_icon_number_image']['url'] ?>" alt="<?php echo $list['optech_list_text']; ?>">
                                        </div>
                                    <?php } ?>
                                </div>
                                <?php if ( !empty( $list['optech_list_text'] ) ) { ?>
                                    <span class="optech-footer-menu-text">
                                        <?php echo $list['optech_list_text']; ?>
                                    </span>
                                <?php } ?>
                            <?php if ( !empty( $list['optech_list_link']['url'] ) ) { ?>
                            </a>
                            <?php } ?>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
		<?php
	}
};
$widgets_manager->register( new \Optech_List_group() );