<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Image Widget .
 *
 */
class Optech_Image_Box extends Widget_Base {

	public function get_name() {
		return 'optechimagebox';
	}
     
	public function get_title() {
		return __( 'Image Box', 'optech' );
	}

	public function get_icon() {
		return 'eicon-code';    
    }

	public function get_categories() {
		return [ 'optech' ];
	}

	protected function register_controls() {

		
		$this->start_controls_section(
			'image_section',
			[
				'label' 	=> __( 'Image Box', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
		$this->add_control(
			'imagebox_layout',
			[
				'label' => __( 'Style', 'optech' ),
				'type' => Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1' => __( 'Style 1', 'optech' ),
					'2' => __( 'Style 2', 'optech' ),
				],
			]
		);
        $this->add_control(
			'image_one',
			[
				'label' 		=> __( 'Main Image', 'optech' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
			'image_two', 
			[
				'label' 		=> __( 'Image Two', 'optech' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
			'image_three',
			[
				'label' 		=> __( 'Shape One', 'optech' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
			'image_four',
			[
				'label' 		=> __( 'Shape Two', 'optech' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->end_controls_section();

	}

	protected function render() {

        $settings = $this->get_settings_for_display();
		$imagebox = $settings[ 'imagebox_layout' ];
		
		?>
			<?php 	
				if ($imagebox) {
					include('image-box/'.$imagebox.'.php');
				}
			?>
		<?php
	}
}
$widgets_manager->register( new \Optech_Image_Box() );