<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Border;
/**
 *
 * Hero Slider Widget .
 *
 */
class Optech_Hero_Slider extends Widget_Base{

	public function get_name() {
		return 'optechheroslider';
	}

	public function get_title() {
		return __( 'Hero Slider', 'optech' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'optech' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'hero_slider_section',
			[
				'label' 	=> __( 'Hero Slider', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
		);
        
		$repeater = new Repeater();

        $repeater->add_control(
			'hero_title',
            [
				'label'         => __( 'Title', 'optech' ),
				'type'          => Controls_Manager::TEXT,
				'default'       => __( 'Affordable big IT & technology solutions' , 'optech' ),
				'label_block'   => true,
			]
		);

		$repeater->add_control(
			'hero_sub_title',
            [
				'label'         => __( 'Hero Sub Title', 'optech' ),
				'type'          => Controls_Manager::TEXT,
				'default'       => __( 'We provide professional IT services' , 'optech' ),
				'label_block'   => true,
			]
		);
        $repeater->add_control(
			'hero_btn_text',
            [
				'label'         => __( 'Button Text', 'optech' ),
				'type'          => Controls_Manager::TEXT,
				'default'       => __( 'Work With Us' , 'optech' ),
				'label_block'   => true,
			]
		);
		$repeater->add_control(
			'hero_btn_url',
			[
				'label' => __( 'Button URL', 'optech' ),
				'type' => Controls_Manager::URL,
				'options' => [ 'url', 'is_external', 'nofollow' ],
				'default' => [
					'url' => '',
					'is_external' => false,
					'nofollow' => false,
				],
				'label_block' => true,
			]
		);
        $repeater->add_control(
			'hero_image',
			[
				'label' 		=> __( 'Slider Image', 'optech' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'slide_items',
			[
				'label' 		=> __( 'Slide Itemes', 'optech' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'hero_title' 		=> __( 'Affordable big IT & technology solutions', 'optech' ),
						'hero_sub_title' 	=> __( 'We provide professional IT services', 'optech' ),
						'hero_btn_text' 	=> __( 'Work With Us', 'optech' ),
                        'hero_image' 	    => Utils::get_placeholder_image_src(),
					],
					[
						'hero_title' 		=> __( 'Software crafting for digital success', 'optech' ),
						'hero_sub_title' 	=> __( 'We provide professional IT services', 'optech' ),
						'hero_btn_text' 	=> __( 'Work With Us', 'optech' ),
                        'hero_image' 	    => Utils::get_placeholder_image_src(),
					],
				],
				'title_field' 	=> '{{{ hero_title }}}',
			]
		);

		$this->end_controls_section();
		// Slider Setting
		$this->start_controls_section(
			'slider_settings',
			[
			'label' => __('Slider Settings', 'optech'),
			'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'arrows',
			[
				'label' => __( 'Arrows?', 'optech' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'optech' ),
				'label_off' => __( 'Hide', 'optech' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'drag',
			[
				'label' => __( 'Drag?', 'optech' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'optech' ),
				'label_off' => __( 'Hide', 'optech' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'autoplay',
			[
				'label' => __( 'Auto Play?', 'optech' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'optech' ),
				'label_off' => __( 'Hide', 'optech' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'autoplaytimeout',
			[
				'label' => __( 'Autoplay Timeout', 'optech' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'label_block' => true,
				'default' => '5000',
				'options' => [
					'1000'  => __( '1 Second', 'optech' ),
					'2000'  => __( '2 Second', 'optech' ),
					'3000'  => __( '3 Second', 'optech' ),
					'4000'  => __( '4 Second', 'optech' ),
					'5000'  => __( '5 Second', 'optech' ),
					'6000'  => __( '6 Second', 'optech' ),
					'7000'  => __( '7 Second', 'optech' ),
					'8000'  => __( '8 Second', 'optech' ),
					'9000'  => __( '9 Second', 'optech' ),
					'10000' => __( '10 Second', 'optech' ),
					'11000' => __( '11 Second', 'optech' ),
					'12000' => __( '12 Second', 'optech' ),
					'13000' => __( '13 Second', 'optech' ),
					'14000' => __( '14 Second', 'optech' ),
					'15000' => __( '15 Second', 'optech' ),
				],
				'condition' => [
					'autoplay' => 'yes',
				],
			]
		);
		$this->end_controls_section();
		// End Slider settings

		$this->start_controls_section(
			'hero_slider_general',
			[
				'label' 	=> __( 'General', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
		$this->add_responsive_control(
			'box_padding',
			[
				'label' 		=> __( 'Padding', 'optech' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .optech-hero-slider-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
		$this->add_responsive_control(
			'box_hight',
			[
				'label' => esc_html__( 'Height', 'textdomain' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'vh', 'custom' ],
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 100,
				],
				'selectors' => [
					'{{WRAPPER}} .optech-hero-slider-item' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

        $this->start_controls_section(
			'hero_slider_title_style_section',
			[
				'label' 	=> __( 'Title', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'hero_slider_title_color',
			[
				'label' 		=> __( 'Color', 'optech' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .optech-hero-content h1' => 'color: {{VALUE}}!important',
				],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'hero_slider_title_typography',
				'label' 	=> __( 'Typography', 'optech' ),
				'selector' 	=> '{{WRAPPER}} .optech-hero-content h1',
			]
        );

        $this->add_responsive_control(
			'hero_slider_title_margin',
			[
				'label' 		=> __( 'Margin', 'optech' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .optech-hero-content h1' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'hero_slider_title_padding',
			[
				'label' 		=> __( 'Padding', 'optech' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .optech-hero-content h1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
			'hero_slider_sub_title_style_section',
			[
				'label' 	=> __( 'Sub Title', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'hero_slider_sub_title_color',
			[
				'label' 	=> __( 'Color', 'optech' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-hero-content h5' => 'color: {{VALUE}} !important',
				],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'hero_slider_sub_title_typography',
				'label' 	=> __( 'Typography', 'optech' ),
				'selector' 	=> '{{WRAPPER}} .optech-hero-content h5',
			]
        );

        $this->add_responsive_control(
			'hero_slider_sub_title_margin',
			[
				'label' 		=> __( 'Margin', 'optech' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .optech-hero-content h5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'hero_slider_sub_title_padding',
			[
				'label' 		=> __( 'Padding', 'optech' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .optech-hero-content h5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

        $this->end_controls_section();

		
        $this->start_controls_section(
			'hero_slider_btn_style_section',
			[
				'label' 	=> __( 'Button', 'optech' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'hero_slider_btn_color',
			[
				'label' 	=> __( 'Color', 'optech' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-default-btn' => 'color: {{VALUE}}!important',
				],
			]
        );

        $this->add_control(
			'hero_slider_btn_bg_color',
			[
				'label' 	=> __( 'Backround Color', 'optech' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-default-btn' => 'background-color: {{VALUE}}!important',
				],
			]
        );

        $this->add_responsive_control(
			'hero_slider_btn_margin',
			[
				'label' 		=> __( 'Margin', 'optech' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .optech-default-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
                ],
			]
        );
		$this->add_responsive_control(
			'hero_slider_btn_padding',
			[
				'label' 		=> __( 'Padding', 'optech' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .optech-default-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
                ],
			]
        );
		$this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'hero_slider_btn_border',
                'label'    => __( 'Border Type', 'optech' ),
                'selector' => '{{WRAPPER}} .optech-default-btn',
            ]
        );

        $this->add_responsive_control(
            'hero_slider_btn_border_radius',
            [
                'label'      => __( 'Border Radius', 'optech' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default'    => [
                    'top'      => '',
                    'right'    => '',
                    'bottom'   => '',
                    'left'     => '',
                    'isLinked' => false
                ],
                'selectors'  => [
                    '{{WRAPPER}} .optech-default-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
            ]
        );
        $this->end_controls_section();
		




	}
	protected function render() {

		$settings = $this->get_settings_for_display();
		//this code course slider option
		$slider_extraSetting = array(
	        'autoplay' => (!empty($settings['autoplay']) && 'yes' === $settings['autoplay']) ? true : false,
            'drag' => (!empty($settings['drag']) && 'yes' === $settings['drag']) ? true : false,
            'arrows' => (!empty($settings['arrows']) && 'yes' === $settings['arrows']) ? true : false,
        	'autoplaytimeout' => !empty($settings['autoplaytimeout']) ? $settings['autoplaytimeout'] : '5000',
        );
        $jasondecode = wp_json_encode($slider_extraSetting);

		//slider attributes data load
		$this->add_render_attribute('slider_attributes', 'class', ['optech-hero-slider']);
        $this->add_render_attribute('slider_attributes', 'data-settings', $jasondecode);

		?>	
        <div <?php echo $this->get_render_attribute_string('slider_attributes'); ?>>
            <?php foreach( $settings['slide_items'] as $single_slider ): ?>
            <div   class=" optech-hero-slider-item " data-animation-in="zoomInImage"  style="background-image: url(<?php if(!empty( $single_slider[ 'hero_image' ] ) ){ echo esc_url( $single_slider[ 'hero_image' ]['url'] ); } ?>)">
                <div class="container">
                    <div class="optech-hero-content center sm" >
						<?php if( !empty( $single_slider[ 'hero_sub_title' ] ) ): ?>
							<h5 data-animation-in="fadeInUp" data-delay-in="0.1"><?php echo esc_html( $single_slider[ 'hero_sub_title' ] ); ?></h5>
						<?php endif; ?>
						<?php if( !empty( $single_slider[ 'hero_title' ] ) ): ?>
							<h1  data-animation-in="fadeInUp" data-delay-in="0.2" ><?php echo esc_html( $single_slider[ 'hero_title' ] ); ?></h1>
						<?php endif; ?>
						<?php if( !empty( $single_slider[ 'hero_btn_text' ] ) && !empty( $single_slider['hero_btn_url']['url'] ) ): ?>
							<div class="optech-extra-mt">
								<a 
									data-animation-in="fadeInUp" 
									data-delay-in="0.3" 
									class="optech-default-btn" 
									href="<?php echo esc_url( $single_slider['hero_btn_url']['url'] ); ?>"
									<?php echo ( !empty( $single_slider['hero_btn_url']['is_external'] ) ) ? 'target="_blank"' : ''; ?>
									<?php echo ( !empty( $single_slider['hero_btn_url']['nofollow'] ) ) ? 'rel="nofollow"' : ''; ?>
									data-text="<?php echo esc_html( $single_slider[ 'hero_btn_text' ] ); ?>"
								>
									<span class="btn-wraper"><?php echo esc_html( $single_slider[ 'hero_btn_text' ] ); ?></span>
								</a>
							</div>
						<?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>

        </div>
		<?php 
	}
}
$widgets_manager->register( new \Optech_Hero_Slider() );