<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Background;
/**
 *
 * Faqs Widget .
 *
 */
class Optech_Faqs extends Widget_Base {

	public function get_name() {
		return 'optechfaqs';
	}

	public function get_title() {
		return __( 'Faqs', 'optech' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'optech' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'faqs_section',
			[
				'label'		 	=> __( 'Faqs', 'optech' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );
        $repeater = new Repeater();
		
		$repeater->add_control(
			'open_item',
			[
				'label' => __( 'Open?', 'optech' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'optech' ),
				'label_off' => __( 'Hide', 'optech' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

        $repeater->add_control(
			'faqs_title',
			[
				'label' 	=> __( 'Title', 'optech' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Initiation & Planning', 'optech' ),
				'label_block' => true,
			]
        );

		$repeater->add_control(
			'faqs_Dec',
			[
				'label' 	=> __( 'Description', 'optech' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Default description', 'optech' ),
				'placeholder' => __( 'Type your description here', 'optech' ),
			]
        );
		$this->add_control(
			'faqs_repeater',
			[
				'label' 		=> __( 'Faqs', 'optech' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' => [
					[
						'faqs_title' => __( 'List Item #1', 'elementor' ),
					],
					[
						'faqs_title' => __( 'List Item #2', 'elementor' ),
					],
					[
						'faqs_title' => __( 'List Item #3', 'elementor' ),
					],
				],
				'title_field' => '{{{ faqs_title }}}'
			]
		);
        $this->end_controls_section();

		// Style Section Start
        $this->start_controls_section(
			'faqs_box_style',
			[
				'label' => __( 'Box', 'optech' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'faqs_box_padding',
			[
				'label'      => __( 'Padding', 'optech' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
                    'top'      => '0',
                    'right'    => '0',
                    'bottom'   => '0',
                    'left'     => '0',
                    'unit'     => 'px',
                    'isLinked' => true
                ],
				'selectors'  => [
					'{{WRAPPER}} .optech-accordion-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_responsive_control(
			'faqs_box_margin',
			[
				'label'      => __( 'Margin', 'optech' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
                    'top'      => '0',
                    'right'    => '0',
                    'bottom'   => '0',
                    'left'     => '0',
                    'unit'     => 'px',
                    'isLinked' => true
                ],
				'selectors'  => [
					'{{WRAPPER}} .optech-accordion-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		$this->end_controls_section();
		
		//Title
		$this->start_controls_section(
			'faqs_title_style',
			[
				'label' => __( 'Title', 'optech' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'faqs_title_color',
			[
				'label' => esc_html__( 'Title Color', 'optech' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-accordion-header h5' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'faqs_title_typography',
				'label' => __( 'Typography', 'optech' ),
				'selector' => '{{WRAPPER}} .optech-accordion-header h5',
			]
		);

		$this->add_responsive_control(
			'faqs_title_padding',
			[
				'label'      => __( 'padding', 'optech' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
                    'top'      => '0',
                    'right'    => '0',
                    'bottom'   => '0',
                    'left'     => '0',
                    'unit'     => 'px',
                    'isLinked' => true
                ],
				'selectors'  => [
					'{{WRAPPER}} .optech-accordion-header h5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		$this->end_controls_section();

		//Text
		$this->start_controls_section(
			'faqs_text_style',
			[
				'label' => __( 'Text', 'optech' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'faqs_text_color',
			[
				'label' => esc_html__( 'Text Color', 'optech' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .optech-accordion-body p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'faqs_text_typography',
				'label' => __( 'Typography', 'optech' ),
				'selector' => '{{WRAPPER}} .optech-accordion-body p',
			]
		);

		$this->add_responsive_control(
			'faqs_text_padding',
			[
				'label'      => __( 'padding', 'optech' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
                    'top'      => '0',
                    'right'    => '0',
                    'bottom'   => '0',
                    'left'     => '0',
                    'unit'     => 'px',
                    'isLinked' => true
                ],
				'selectors'  => [
					'{{WRAPPER}} .optech-accordion-body p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		$this->end_controls_section();

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		?>
        <div class="optech-accordion-wrap init-wrap">
			<?php foreach( $settings['faqs_repeater'] as $single_faq ):
				$open_item = '';

				if( 'yes' == $single_faq['open_item'] ){
					$open_item = 'open';
				}else{
					$open_item = '';
				}
				
				?>
				<div class="optech-accordion-item <?php echo esc_attr( $open_item ); ?>">
					<div class="optech-accordion-header init-header">
						<h5><?php echo esc_html( $single_faq['faqs_title'] ); ?></h5>
					</div>
					<div class="optech-accordion-body init-body">
						<p><?php echo esc_html( $single_faq['faqs_Dec'] ); ?></p>
					</div>
				</div>
			<?php endforeach; ?>
        </div>
		<?php
	}
}
$widgets_manager->register( new \Optech_Faqs() );