<div class="row">
    <?php if ($the_query->have_posts()) {
        while ($the_query->have_posts()) {
            $the_query->the_post();
            $excerpt = (isset($settings['excerpt_limit']['size']) && $settings['excerpt_limit']['size']) 
                        ? wp_trim_words(get_the_excerpt(), $settings['excerpt_limit']['size'], '') 
                        : get_the_excerpt();
    ?>
        <div <?php echo $this->get_render_attribute_string('blog_gride_classes'); ?> data-aos="fade-up" data-aos-duration="600">
            <div class="optech-blog blog-single  blog-column has-post-thumbnail">
                <div class="blog-img">
                    <?php if( has_post_thumbnail() ): ?>
                        <a href="<?php the_permalink(); ?>">
                            <?php the_post_thumbnail('full');?>
                        </a>
                    <?php endif; ?>

                </div>
                <div class="blog-content">
                    <div class="blog-meta">
                        <?php
                            $categories = get_the_category();
                            if (!empty($categories)) {
                                $category = $categories[0]; // Get the first category
                                echo '<a href="' . esc_url(get_category_link($category->term_id)) . '">' . esc_html($category->name) . '</a>';
                            }
                        ?>
                        <?php if( $settings['show_date'] == 'yes' ): ?>
                            <a href="<?php echo get_day_link(get_the_time('Y'), get_the_time('m'), get_the_time('d')); ?>">
                                <?php echo get_the_time('M j, Y'); ?>
                            </a>
                        <?php endif; ?>
                    </div>

                    <h4 class="blog-title-sm">
                        <a href="<?php the_permalink(); ?>">
                            <?php the_title(); ?>
                        </a>
                    </h4>

                    <div class="optech-excerpt">
                        <?php if( $settings['show_excerpt'] == 'yes' ): ?>
                            <?php echo esc_html( $excerpt ); ?>
                        <?php endif; ?>
                    </div> 

                    <?php if( $settings['show_btn'] == 'yes' ): ?>
                        <a class="optech-icon-btn" href="<?php the_permalink(); ?>">
                            <i class="icon-show ri-arrow-right-line"></i>
                            <span><?php echo esc_html($settings['button_text']); ?></span>
                            <i class="icon-hide ri-arrow-right-line"></i>
                        </a>
                    <?php endif; ?>

                </div>
            </div>
        </div>
    <?php
        
        }
        // Restore original Post Data.
        wp_reset_postdata();
    }
?>
</div>    

                